/*
 * Decompiled with CFR 0.152.
 */
package org.kefirsf.bb.util;

import java.util.Arrays;
import org.kefirsf.bb.util.Exceptions;

public final class ArrayCharSequence
implements CharSequence {
    private final char[] text;
    private final int offset;
    private final int length;

    public ArrayCharSequence(char[] text, int offset, int length) {
        Exceptions.nullArgument("text", text);
        Exceptions.negativeArgument("offset", offset);
        Exceptions.negativeArgument("length", length);
        if (offset + length > text.length) {
            throw new ArrayIndexOutOfBoundsException("The breaks are wrong.");
        }
        this.text = text;
        this.offset = offset;
        this.length = length;
    }

    public int length() {
        return this.length;
    }

    public char charAt(int index) {
        return this.text[index + this.offset];
    }

    public CharSequence subSequence(int start, int end) {
        return new ArrayCharSequence(this.text, start + this.offset, end - start);
    }

    public String toString() {
        return String.valueOf(this.text, this.offset, this.length);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ArrayCharSequence)) {
            return false;
        }
        ArrayCharSequence that = (ArrayCharSequence)o;
        if (this.length != that.length) {
            return false;
        }
        if (this.offset != that.offset) {
            return false;
        }
        return Arrays.equals(this.text, that.text);
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.text);
        result = 31 * result + this.offset;
        result = 31 * result + this.length;
        return result;
    }
}

