/*
 * Decompiled with CFR 0.152.
 */
package org.kefirsf.bb.util;

public final class IntSet {
    private static final int TABLE_SIZE = 256;
    private static final int MASK = 255;
    private static final int INITIAL_CAPACITY = 16;
    private final int[][] table = new int[256][];
    private final int[] lengths = new int[256];

    public void add(int value) {
        int rowIndex = IntSet.rowIndex(value);
        int[] row = this.table[rowIndex];
        if (row == null) {
            row = new int[16];
            this.table[rowIndex] = row;
            row[0] = value;
            int n = rowIndex;
            this.lengths[n] = this.lengths[n] + 1;
        } else {
            int index;
            int length = this.lengths[rowIndex];
            if (length >= row.length) {
                int newLength = 2 * row.length;
                int[] copyRow = new int[newLength];
                System.arraycopy(row, 0, copyRow, 0, row.length);
                row = copyRow;
                this.table[rowIndex] = copyRow;
            }
            if ((index = IntSet.binarySearch(row, length, value)) < 0) {
                int temp = value;
                for (int i = -index - 1; i < length; ++i) {
                    int temp1 = row[i];
                    row[i] = temp;
                    temp = temp1;
                }
                row[length] = temp;
                int n = rowIndex;
                this.lengths[n] = this.lengths[n] + 1;
            }
        }
    }

    private static int binarySearch(int[] array, int toIndex, int key) {
        int low = 0;
        int high = toIndex - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            int midVal = array[mid];
            if (midVal < key) {
                low = mid + 1;
                continue;
            }
            if (midVal > key) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public boolean contains(int value) {
        int rowIndex = IntSet.rowIndex(value);
        int length = this.lengths[rowIndex];
        return length > 0 && IntSet.binarySearch(this.table[rowIndex], length, value) >= 0;
    }

    private static int rowIndex(int value) {
        return value & 0xFF;
    }
}

