/*
 * Decompiled with CFR 0.152.
 */
package org.kefirsf.bb.conf;

import java.util.ArrayList;
import java.util.List;
import org.kefirsf.bb.conf.Pattern;
import org.kefirsf.bb.conf.Template;
import org.kefirsf.bb.util.Exceptions;
import org.kefirsf.bb.util.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Code {
    public static final int DEFAULT_PRIORITY = 0;
    private String name;
    private int priority = 0;
    private List<Pattern> patterns;
    private Template template;
    private boolean transparent = true;

    public Code() {
        this.name = Utils.generateRandomName();
    }

    public Code(String name) {
        Exceptions.nullArgument("name", name);
        this.name = name;
    }

    public Code(Pattern pattern, Template template, String name, int priority) {
        Exceptions.nullArgument("name", name);
        this.name = name;
        this.priority = priority;
        this.addPattern(pattern);
        this.template = template;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        Exceptions.nullArgument("name", name);
        this.name = name;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public List<Pattern> getPatterns() {
        return this.patterns;
    }

    public void setPatterns(List<Pattern> patterns) {
        this.patterns = patterns;
    }

    public void addPattern(Pattern pattern) {
        if (this.patterns == null) {
            this.patterns = new ArrayList<Pattern>();
        }
        this.patterns.add(pattern);
    }

    public boolean hasPatterns() {
        return this.patterns != null && !this.patterns.isEmpty();
    }

    @Deprecated
    public Pattern getPattern() {
        if (this.patterns != null && !this.patterns.isEmpty()) {
            return this.patterns.get(0);
        }
        return null;
    }

    @Deprecated
    public void setPattern(Pattern pattern) {
        this.patterns = new ArrayList<Pattern>(1);
        this.patterns.add(pattern);
    }

    public Template getTemplate() {
        return this.template;
    }

    public void setTemplate(Template template) {
        this.template = template;
    }

    public boolean isTransparent() {
        return this.transparent;
    }

    public void setTransparent(boolean transparent) {
        this.transparent = transparent;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Code code = (Code)o;
        return this.name.equals(code.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }
}

