/*
 * Decompiled with CFR 0.152.
 */
package org.kefirsf.bb.proc;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.kefirsf.bb.proc.Context;
import org.kefirsf.bb.proc.NestingException;
import org.kefirsf.bb.proc.ProcNamedElement;
import org.kefirsf.bb.proc.ProcPatternElement;
import org.kefirsf.bb.proc.Source;

public abstract class AbstractUrl
extends ProcNamedElement
implements ProcPatternElement {
    static final Pattern REGEX_AUTHORITY = Pattern.compile("[\\w\\.\\-~_!\\$&'\\(\\)%;:=\\+,\\*]+(:[\\w\\.\\-~_!\\$&'\\(\\)%;:=\\+,\\*]+)?@");
    private static final Pattern REGEX_HOST = Pattern.compile("([\\da-zA-Z](\\-?\\w+)*\\.)*[\\da-zA-Z](\\-?\\w+)*\\.?");
    private static final Pattern REGEX_QUERY = Pattern.compile("\\?(([\\w%\\-\\+]|(%\\p{XDigit}{2}))+(=([\\w%\\-\\+]|(%\\p{XDigit}{2}))+)?(&|;))*(([\\w%\\-\\+]|(%\\p{XDigit}{2}))+(=([\\w%\\-\\+]|(%\\p{XDigit}{2}))+)?)?");
    protected final boolean ghost;

    public AbstractUrl(String name, boolean ghost) {
        super(name);
        this.ghost = ghost;
    }

    public boolean parse(Context context, ProcPatternElement terminator) throws NestingException {
        Source source = context.getSource();
        int length = this.parseLength(source, source.getOffset(), terminator);
        if (length >= 0) {
            context.setAttribute(this.getName(), source.sub(source.getOffset() + length));
            if (!this.ghost) {
                source.incOffset(length);
            }
            return true;
        }
        return false;
    }

    public boolean isNextIn(Context context) {
        Source source = context.getSource();
        return this.parseLength(source, source.getOffset(), context.getTerminator()) >= 0;
    }

    public abstract int findIn(Source var1);

    abstract int parseLength(Source var1, int var2, ProcPatternElement var3);

    int parseHost(Source source, int offset, ProcPatternElement terminator) {
        return this.parseRegex(source, offset, this.calcEnd(source, terminator), REGEX_HOST);
    }

    protected int calcEnd(Source source, ProcPatternElement terminator) {
        int ind;
        int end = source.length();
        if (terminator != null && (ind = terminator.findIn(source)) > 0) {
            end = ind;
        }
        return end;
    }

    protected int parseRegex(Source source, int offset, int end, Pattern pattern) {
        CharSequence seq = source.subSequence(offset, end);
        Matcher matcher = pattern.matcher(seq);
        if (matcher.lookingAt()) {
            return matcher.group().length();
        }
        return 0;
    }

    int parseAuthority(Source source, int offset) {
        return this.parseRegex(source, offset, source.length(), REGEX_AUTHORITY);
    }

    int parseQuery(Source source, int offset, ProcPatternElement terminator) {
        return this.parseRegex(source, offset, this.calcEnd(source, terminator), REGEX_QUERY);
    }
}

