/*
 * Decompiled with CFR 0.152.
 */
package org.kefirsf.bb.proc;

import org.kefirsf.bb.proc.Context;
import org.kefirsf.bb.proc.ProcPatternElement;
import org.kefirsf.bb.proc.Source;

public class PatternConstant
implements ProcPatternElement {
    private final String value;
    private final char[] chars;
    private final boolean ignoreCase;
    private final int valueLength;
    private final boolean ghost;

    public PatternConstant(String value, boolean ignoreCase) {
        this.value = value;
        this.chars = value.toCharArray();
        this.valueLength = value.length();
        this.ignoreCase = ignoreCase;
        this.ghost = false;
    }

    public PatternConstant(String value, boolean ignoreCase, boolean ghost) {
        this.value = value;
        this.chars = value.toCharArray();
        this.valueLength = value.length();
        this.ignoreCase = ignoreCase;
        this.ghost = ghost;
    }

    public boolean parse(Context context, ProcPatternElement terminator) {
        if (this.isNextIn(context)) {
            if (!this.ghost) {
                context.getSource().incOffset(this.valueLength);
            }
            return true;
        }
        return false;
    }

    public boolean isNextIn(Context context) {
        return context.getSource().nextIs(this);
    }

    public int findIn(Source source) {
        return source.find(this);
    }

    public String getValue() {
        return this.value;
    }

    public boolean isIgnoreCase() {
        return this.ignoreCase;
    }

    public char[] getCharArray() {
        return this.chars;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PatternConstant that = (PatternConstant)o;
        if (this.ignoreCase != that.ignoreCase) {
            return false;
        }
        return this.value.equals(that.value);
    }

    public int hashCode() {
        int result = this.value.hashCode();
        result = 31 * result + (this.ignoreCase ? 1 : 0);
        return result;
    }

    public String toString() {
        return this.value;
    }
}

