/*
 * Decompiled with CFR 0.152.
 */
package org.kefirsf.bb.proc;

import org.kefirsf.bb.proc.AbstractEol;
import org.kefirsf.bb.proc.Source;

public class ProcBlankLine
extends AbstractEol {
    private static final char[] WS = new char[]{' ', '\u00a0', '\u180e', '\u2000', '\u2001', '\u2002', '\u2003', '\u2004', '\u2005', '\u2006', '\u2007', '\u2008', '\u2009', '\u200a', '\u200b', '\u202f', '\u205f', '\u3000', '\t', '\ufeff'};

    public ProcBlankLine(boolean ghost) {
        super(ghost);
    }

    protected int match(Source source, int index) {
        int ind = index;
        int len = this.calcLength(source, ind);
        if (len < 0) {
            return -1;
        }
        ind += len;
        while (ind < source.length() && this.whitespace(source.charAt(ind))) {
            ++ind;
        }
        len = this.calcLength(source, ind);
        if (len < 0) {
            return -1;
        }
        return (ind += len) - index;
    }

    private boolean whitespace(char c) {
        for (char p : WS) {
            if (c != p) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("<blankline");
        if (this.ghost) {
            b.append(" ghost=\"true\"");
        }
        b.append("/>");
        return b.toString();
    }
}

