/*
 * Decompiled with CFR 0.152.
 */
package org.kefirsf.bb.proc;

import java.util.List;
import java.util.Map;
import org.kefirsf.bb.proc.Context;
import org.kefirsf.bb.proc.NestingException;
import org.kefirsf.bb.proc.ProcPattern;
import org.kefirsf.bb.proc.ProcTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcCode
implements Comparable<ProcCode> {
    private final Logger logGenerate = LoggerFactory.getLogger((String)"kefirbb.generate");
    private final Logger logContext = LoggerFactory.getLogger((String)"kefirbb.context");
    private final ProcTemplate template;
    private final List<ProcPattern> patterns;
    private final int priority;
    private final String name;
    private final boolean transparent;

    public ProcCode(List<ProcPattern> patterns, ProcTemplate template, String name, int priority, boolean transparent) {
        this.template = template;
        this.priority = priority;
        this.name = name;
        this.patterns = patterns;
        this.transparent = transparent;
    }

    public boolean process(Context context) throws NestingException {
        for (ProcPattern pattern : this.patterns) {
            Context codeContext;
            if (!pattern.parse(codeContext = new Context(context))) continue;
            if (this.transparent) {
                codeContext.mergeWithParent();
            }
            this.template.generate(codeContext);
            if (this.logContext.isTraceEnabled()) {
                for (Map.Entry<String, CharSequence> entry : context.getAttributes().entrySet()) {
                    this.logContext.trace("Context: {} = {}", (Object)entry.getKey(), (Object)entry.getValue());
                }
            }
            if (this.logGenerate.isTraceEnabled()) {
                this.logGenerate.trace("Generated text: {}", (Object)codeContext.getTarget());
            }
            return true;
        }
        return false;
    }

    public boolean suspicious(Context context) {
        for (ProcPattern pattern : this.patterns) {
            if (!pattern.suspicious(context)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int compareTo(ProcCode code) {
        return this.priority - code.priority;
    }

    public boolean startsWithConstant() {
        for (ProcPattern pattern : this.patterns) {
            if (pattern.startsWithConstant()) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProcCode procCode = (ProcCode)o;
        return !(this.name != null ? !this.name.equals(procCode.name) : procCode.name != null);
    }

    public int hashCode() {
        return this.name != null ? this.name.hashCode() : 0;
    }

    public boolean containsCheck() {
        for (ProcPattern pattern : this.patterns) {
            if (!pattern.hasCheck()) continue;
            return true;
        }
        return false;
    }
}

