/*
 * Decompiled with CFR 0.152.
 */
package org.kefirsf.bb.proc;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.kefirsf.bb.proc.AbstractUrl;
import org.kefirsf.bb.proc.ProcPatternElement;
import org.kefirsf.bb.proc.Source;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcUrl
extends AbstractUrl {
    private static final String pct_encoded = "(%\\p{XDigit}{2})";
    private static final String pchar = "[\\w~!$&'*+,;=:@\\(\\)\\.\\-]|(%\\p{XDigit}{2})";
    private static final Pattern REGEX_PORT = Pattern.compile(":\\d{1,4}");
    private static final Pattern REGEX_PATH = Pattern.compile("(/([\\w~!$&'*+,;=:@\\(\\)\\.\\-]|(%\\p{XDigit}{2}))+)*/?");
    private static final Pattern REGEX_FRAGMENT = Pattern.compile("#([\\w~!$&'*+,;=:@\\(\\)\\.\\-]|(%\\p{XDigit}{2})|[/?])*");
    private static final Pattern REGEX_LOCAL_PREFIX = Pattern.compile("\\.{0,2}/");
    private static final String[] LOCAL_PREFIXES = new String[]{"/", "./", "../"};
    private final boolean local;
    private final boolean schemaless;

    public ProcUrl(String name, boolean ghost, boolean local, boolean schemaless) {
        super(name, ghost);
        this.local = local;
        this.schemaless = schemaless;
    }

    @Override
    public int findIn(Source source) {
        int index;
        if (this.schemaless) {
            return -1;
        }
        int start = source.getOffset();
        int sourceLength = source.length();
        int length = -1;
        do {
            index = sourceLength;
            List<String> prefixes = this.preparePrefixes();
            for (String prefix : prefixes) {
                int ni = source.findFrom(start, prefix.toCharArray(), true);
                if (ni <= 0 || ni >= index) continue;
                index = ni;
            }
            if (index >= sourceLength || (length = this.parseLength(source, index, null)) >= 0) continue;
            start = index + 1;
        } while (length < 0 && index < sourceLength);
        if (length >= 0) {
            return index;
        }
        return -1;
    }

    private List<String> preparePrefixes() {
        ArrayList<String> prefixes = new ArrayList<String>(Schema.values().length + (this.local ? 3 : 0));
        for (Schema schema : Schema.values()) {
            prefixes.add(schema.getPrefix());
        }
        if (this.local) {
            Collections.addAll(prefixes, LOCAL_PREFIXES);
        }
        return prefixes;
    }

    @Override
    int parseLength(Source source, int offset, ProcPatternElement terminator) {
        int length = 0;
        Schema schema = this.parseSchema(source, offset);
        if (schema != null && !this.schemaless) {
            length += schema.getLength();
        } else if (schema == null && !this.local && !this.schemaless || schema != null) {
            return -1;
        }
        if (schema != null) {
            int authorityLength = this.parseAuthority(source, offset + length);
            if (schema.isAuthorityMandatory() && authorityLength <= 0) {
                return -1;
            }
            length += authorityLength;
        }
        if (schema != null || this.schemaless) {
            int hostLength = this.parseHost(source, offset + length, terminator);
            if (hostLength <= 0) {
                return -1;
            }
            length += hostLength;
        }
        if (schema != null || this.schemaless) {
            int portLength = this.parsePort(source, offset + length);
            length += portLength;
        }
        if (schema == null && this.local) {
            int prefixLength = this.parseRegex(source, offset, this.calcEnd(source, terminator), REGEX_LOCAL_PREFIX);
            if (prefixLength <= 0) {
                return -1;
            }
            length += prefixLength - 1;
        }
        int pathLength = this.parsePath(source, offset + length, terminator);
        if (this.local && schema == null && pathLength <= 0) {
            return -1;
        }
        length += pathLength;
        length += this.parseQuery(source, offset + length, terminator);
        length += this.parseFragment(source, offset + length, terminator);
        return length;
    }

    int parseFragment(Source source, int offset, ProcPatternElement terminator) {
        return this.parseRegex(source, offset, this.calcEnd(source, terminator), REGEX_FRAGMENT);
    }

    int parsePath(Source source, int offset, ProcPatternElement terminator) {
        return this.parseRegex(source, offset, this.calcEnd(source, terminator), REGEX_PATH);
    }

    private int parsePort(Source source, int offset) {
        return this.parseRegex(source, offset, source.length(), REGEX_PORT);
    }

    Schema parseSchema(Source source, int offset) {
        for (Schema schema : Schema.values()) {
            String str = ((Object)source.subSequence(offset, Math.min(offset + schema.getLength(), source.length()))).toString();
            if (!schema.getPrefix().equalsIgnoreCase(str)) continue;
            return schema;
        }
        return null;
    }

    public String toString() {
        return MessageFormat.format("<url name=\"{0}\" ghost=\"{1}\" local=\"{2}\" schemaless=\"{3}\"/>", this.getName(), this.ghost, this.local, this.schemaless);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Schema {
        HTTP("http://"),
        HTTPS("https://"),
        FTP("ftp://"),
        MAILTO("mailto:", true);

        private final String prefix;
        private final boolean authorityMandatory;

        private Schema(String prefix) {
            this.prefix = prefix;
            this.authorityMandatory = false;
        }

        private Schema(String prefix, boolean authorityMandatory) {
            this.prefix = prefix;
            this.authorityMandatory = authorityMandatory;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public boolean isAuthorityMandatory() {
            return this.authorityMandatory;
        }

        public int getLength() {
            return this.prefix.length();
        }
    }
}

