/*
 * Decompiled with CFR 0.152.
 */
package org.kefirsf.bb.proc;

import java.text.MessageFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.kefirsf.bb.conf.Action;
import org.kefirsf.bb.proc.Context;
import org.kefirsf.bb.proc.ProcNamedElement;
import org.kefirsf.bb.proc.ProcPatternElement;
import org.kefirsf.bb.proc.Source;

public class ProcVariable
extends ProcNamedElement
implements ProcPatternElement {
    private final Pattern regex;
    private final boolean ghost;
    private final Action action;

    public ProcVariable(String name, Pattern regex, boolean ghost, Action action) {
        super(name);
        this.regex = regex;
        this.ghost = ghost;
        this.action = action;
    }

    public boolean parse(Context context, ProcPatternElement terminator) {
        int end;
        Source source = context.getSource();
        int offset = source.getOffset();
        if (terminator != null && !this.ghost) {
            end = terminator.findIn(source);
            if (end < 0) {
                if (this.regex == null) {
                    return false;
                }
                end = source.length();
            }
        } else {
            end = source.length();
        }
        CharSequence value = source.sub(end);
        if (this.regex != null) {
            Matcher matcher = this.regex.matcher(value);
            if (matcher.lookingAt()) {
                int lend = matcher.end();
                end = offset + lend;
                value = matcher.group();
            } else {
                return false;
            }
        }
        CharSequence old = (CharSequence)context.getAttribute(this.getName());
        CharSequence attr = (CharSequence)context.getLocalAttribute(this.getName());
        if (attr == null || attr.equals(value)) {
            if (attr == null) {
                if (this.action == Action.rewrite) {
                    this.setAttribute(context, value);
                } else if (old != null) {
                    this.setAttribute(context, new StringBuilder().append(old).append(value));
                } else {
                    this.setAttribute(context, value);
                }
            }
            if (!this.ghost) {
                source.incOffset(end - offset);
            }
            return true;
        }
        return false;
    }

    public boolean isNextIn(Context context) {
        return this.regex == null || this.regex.matcher(context.getSource().subToEnd()).lookingAt();
    }

    public int findIn(Source source) {
        if (this.regex != null) {
            Matcher matcher = this.regex.matcher(source.subToEnd());
            if (matcher.find()) {
                return source.getOffset() + matcher.start();
            }
            return -1;
        }
        return -1;
    }

    public String toString() {
        return MessageFormat.format("<var name=\"{0}\" regex=\"{1}\" action=\"{2}\" ghost=\"{3}\"/>", new Object[]{this.getName(), this.regex, this.action, this.ghost});
    }
}

