/*
 * Decompiled with CFR 0.152.
 */
package org.kefirsf.bb.proc;

import java.util.Arrays;
import java.util.Set;
import java.util.TreeSet;
import org.kefirsf.bb.proc.PatternConstant;
import org.kefirsf.bb.util.ArrayCharSequence;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Source
implements CharSequence {
    private final char[] text;
    private final int textLength;
    private int offset = 0;
    private Set<PatternConstant> constantSet;
    private char[] constantChars;

    public boolean nextMayBeConstant() {
        return Arrays.binarySearch(this.constantChars, this.text[this.offset]) >= 0;
    }

    public Source(CharSequence text) {
        this.textLength = text.length();
        this.text = new char[this.textLength];
        if (text instanceof String) {
            ((String)text).getChars(0, this.textLength, this.text, 0);
        } else if (text instanceof StringBuilder) {
            ((StringBuilder)text).getChars(0, this.textLength, this.text, 0);
        } else if (text instanceof StringBuffer) {
            ((StringBuffer)text).getChars(0, this.textLength, this.text, 0);
        } else {
            ((Object)text).toString().getChars(0, this.textLength, this.text, 0);
        }
    }

    public void setConstantSet(Set<PatternConstant> constantSet) {
        this.constantSet = constantSet;
        this.constantChars = this.getConstantChars();
    }

    private char[] getConstantChars() {
        TreeSet<Character> chars = new TreeSet<Character>();
        chars.add(Character.valueOf('\n'));
        chars.add(Character.valueOf('\r'));
        for (PatternConstant constant : this.constantSet) {
            char c = constant.getValue().charAt(0);
            if (constant.isIgnoreCase()) {
                chars.add(Character.valueOf(Character.toLowerCase(c)));
                chars.add(Character.valueOf(Character.toUpperCase(c)));
                continue;
            }
            chars.add(Character.valueOf(c));
        }
        char[] cs = new char[chars.size()];
        int j = 0;
        for (Character c : chars) {
            cs[j] = c.charValue();
            ++j;
        }
        Arrays.sort(cs);
        return cs;
    }

    public boolean nextIs(PatternConstant constant) {
        char[] cs = constant.getCharArray();
        int length = cs.length;
        if (length > this.textLength - this.offset) {
            return false;
        }
        if (!constant.isIgnoreCase()) {
            int i;
            for (i = 0; i < length && this.text[this.offset + i] == cs[i]; ++i) {
            }
            return i == length;
        }
        for (int i = 0; i < length; ++i) {
            char ct = this.text[this.offset + i];
            char cv = cs[i];
            if (ct == cv || Character.toUpperCase(ct) == Character.toUpperCase(cv) || Character.toLowerCase(ct) == Character.toLowerCase(cv)) continue;
            return false;
        }
        return true;
    }

    public int find(PatternConstant constant) {
        char[] cs = constant.getCharArray();
        boolean ignoreCase = constant.isIgnoreCase();
        return this.find(cs, ignoreCase);
    }

    public int find(char[] chars, boolean ignoreCase) {
        return this.findFrom(this.offset, chars, ignoreCase);
    }

    public int findFrom(int index, char[] chars, boolean ignoreCase) {
        int length = chars.length;
        for (int i = index; i < this.textLength - length + 1; ++i) {
            boolean flag = true;
            for (int j = 0; j < length && flag; ++j) {
                char ct = this.text[i + j];
                char cv = chars[j];
                flag = ct == cv || ignoreCase && (Character.toUpperCase(ct) == Character.toUpperCase(cv) || Character.toLowerCase(ct) == Character.toLowerCase(cv));
            }
            if (!flag) continue;
            return i;
        }
        return -1;
    }

    public char next() {
        char c = this.text[this.offset];
        this.incOffset();
        return c;
    }

    @Override
    public char charAt(int index) {
        return this.text[index];
    }

    public int getOffset() {
        return this.offset;
    }

    public void incOffset() {
        ++this.offset;
    }

    public void incOffset(int increment) {
        this.offset += increment;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public boolean hasNext() {
        return this.offset < this.textLength;
    }

    @Override
    public int length() {
        return this.textLength;
    }

    public CharSequence sub(int end) {
        return new ArrayCharSequence(this.text, this.offset, end - this.offset);
    }

    public CharSequence subToEnd() {
        return this.sub(this.textLength);
    }

    @Override
    public String toString() {
        return String.valueOf(this.textLength);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return new ArrayCharSequence(this.text, start, end - start);
    }
}

