/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.intern.color;

import bibliothek.gui.Dockable;
import bibliothek.gui.dock.common.ColorMap;
import bibliothek.gui.dock.common.intern.CDockable;
import bibliothek.gui.dock.common.intern.CommonDockable;
import bibliothek.gui.dock.common.intern.color.ColorTransmitter;
import bibliothek.gui.dock.themes.color.TabColor;
import bibliothek.gui.dock.util.color.ColorManager;
import bibliothek.gui.dock.util.color.DockColor;
import java.awt.Color;

public abstract class TabColorTransmitter
extends ColorTransmitter {
    private ColorManager manager;
    private String[] keys;

    public TabColorTransmitter(ColorManager manager, String ... keys) {
        super(keys);
        this.keys = keys;
        this.manager = manager;
    }

    protected abstract Color convert(Color var1, String var2);

    protected abstract Color convertSelected(Color var1, String var2);

    protected abstract Color convertFocused(Color var1, String var2);

    @Override
    protected Color get(Color color, String id, DockColor observer) {
        CDockable dockable = this.getDockable(observer);
        if (dockable != null) {
            return this.get(color, id, dockable);
        }
        return color;
    }

    protected abstract boolean isForeground(String var1);

    protected abstract boolean isSelected(String var1);

    protected abstract boolean isFocused(String var1);

    @Override
    protected Color get(Color color, String id, CDockable dockable) {
        Color check = null;
        ColorMap colors = dockable.getColors();
        boolean foreground = this.isForeground(id);
        boolean selected = this.isSelected(id);
        boolean focused = this.isFocused(id);
        if (foreground) {
            if (focused) {
                check = colors.getColor("tab.foreground.focused");
            }
            if (check == null && (focused || selected)) {
                check = colors.getColor("tab.foreground.selected");
            }
            if (check == null) {
                check = colors.getColor("tab.foreground");
            }
        }
        if (check == null) {
            if (focused && (check = colors.getColor("tab.background.focused")) != null) {
                check = this.convertFocused(check, id);
            }
            if (check == null && (focused || selected) && (check = colors.getColor("tab.background.selected")) != null) {
                check = this.convertSelected(check, id);
            }
            if (check == null && (check = colors.getColor("tab.background")) != null) {
                check = this.convert(check, id);
            }
        }
        if (check != null) {
            return check;
        }
        return color;
    }

    @Override
    protected void update(CDockable dockable, String key, Color color) {
        boolean change;
        boolean bl = change = "tab.background".equals(key) || "tab.background.focused".equals(key) || "tab.background.selected".equals(key) || "tab.foreground".equals(key) || "tab.foreground.focused".equals(key) || "tab.foreground.selected".equals(key);
        if (change) {
            for (String check : this.keys) {
                this.set(check, this.get((Color)this.manager.get(check), check, dockable), dockable);
            }
        }
    }

    @Override
    protected CDockable getDockable(DockColor observer) {
        Dockable dockable = ((TabColor)observer).getDockable();
        if (dockable instanceof CommonDockable) {
            return ((CommonDockable)dockable).getDockable();
        }
        return null;
    }
}

