/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.example.multitenant.control;

import java.io.InputStream;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.keycloak.adapters.KeycloakConfigResolver;
import org.keycloak.adapters.KeycloakDeployment;
import org.keycloak.adapters.KeycloakDeploymentBuilder;
import org.keycloak.adapters.spi.HttpFacade;

public class PathBasedKeycloakConfigResolver
implements KeycloakConfigResolver {
    private final Map<String, KeycloakDeployment> cache = new ConcurrentHashMap();

    public KeycloakDeployment resolve(HttpFacade.Request request) {
        KeycloakDeployment deployment;
        String path = request.getURI();
        int multitenantIndex = path.indexOf("multitenant/");
        if (multitenantIndex == -1) {
            throw new IllegalStateException("Not able to resolve realm from the request path!");
        }
        String realm = path.substring(path.indexOf("multitenant/")).split("/")[1];
        if (realm.contains("?")) {
            realm = realm.split("\\?")[0];
        }
        if (null == (deployment = (KeycloakDeployment)this.cache.get(realm))) {
            InputStream is = this.getClass().getResourceAsStream("/" + realm + "-keycloak.json");
            if (is == null) {
                throw new IllegalStateException("Not able to find the file /" + realm + "-keycloak.json");
            }
            deployment = KeycloakDeploymentBuilder.build((InputStream)is);
            this.cache.put(realm, deployment);
        }
        return deployment;
    }
}

