/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.core.interception;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.WriterInterceptor;
import javax.ws.rs.ext.WriterInterceptorContext;
import org.jboss.resteasy.resteasy_jaxrs.i18n.LogMessages;
import org.jboss.resteasy.resteasy_jaxrs.i18n.Messages;
import org.jboss.resteasy.spi.ResteasyProviderFactory;

public abstract class AbstractWriterInterceptorContext
implements WriterInterceptorContext {
    protected WriterInterceptor[] interceptors;
    protected Object entity;
    protected Class type;
    protected Type genericType;
    protected Annotation[] annotations;
    protected MediaType mediaType;
    protected MultivaluedMap<String, Object> headers;
    protected OutputStream outputStream;
    protected int index = 0;
    protected ResteasyProviderFactory providerFactory;

    public AbstractWriterInterceptorContext(WriterInterceptor[] interceptors, Annotation[] annotations, Object entity, Type genericType, MediaType mediaType, Class type, OutputStream outputStream, ResteasyProviderFactory providerFactory, MultivaluedMap<String, Object> headers) {
        this.providerFactory = providerFactory;
        this.interceptors = interceptors;
        this.annotations = annotations;
        this.entity = entity;
        this.genericType = genericType;
        this.mediaType = mediaType;
        this.type = type;
        this.outputStream = outputStream;
        this.headers = headers;
    }

    @Override
    public Object getEntity() {
        return this.entity;
    }

    @Override
    public void setEntity(Object entity) {
        this.entity = entity;
    }

    public Class getType() {
        return this.type;
    }

    public void setType(Class type) {
        this.type = type;
    }

    @Override
    public Type getGenericType() {
        return this.genericType;
    }

    @Override
    public void setGenericType(Type genericType) {
        this.genericType = genericType;
    }

    @Override
    public Annotation[] getAnnotations() {
        return this.annotations;
    }

    @Override
    public void setAnnotations(Annotation[] annotations) {
        if (annotations == null) {
            throw new NullPointerException(Messages.MESSAGES.annotationsParamNull());
        }
        this.annotations = annotations;
    }

    @Override
    public MediaType getMediaType() {
        return this.mediaType;
    }

    @Override
    public void setMediaType(MediaType mediaType) {
        this.mediaType = mediaType;
    }

    @Override
    public MultivaluedMap<String, Object> getHeaders() {
        return this.headers;
    }

    @Override
    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    @Override
    public void setOutputStream(OutputStream outputStream) {
        this.outputStream = outputStream;
    }

    @Override
    public void proceed() throws IOException, WebApplicationException {
        LogMessages.LOGGER.debugf("Interceptor Context: %s,  Method : proceed", (Object)this.getClass().getName());
        if (this.interceptors == null || this.index >= this.interceptors.length) {
            MessageBodyWriter writer = this.getWriter();
            if (writer != null) {
                LogMessages.LOGGER.debugf("MessageBodyWriter: %s", (Object)writer.getClass().getName());
            }
            this.writeTo(writer);
        } else {
            LogMessages.LOGGER.debugf("WriterInterceptor: %s", (Object)this.interceptors[this.index].getClass().getName());
            this.interceptors[this.index++].aroundWriteTo(this);
        }
    }

    protected void writeTo(MessageBodyWriter writer) throws IOException {
        writer.writeTo(this.entity, this.type, this.genericType, this.annotations, this.mediaType, this.headers, this.outputStream);
    }

    protected MessageBodyWriter getWriter() {
        MessageBodyWriter writer = this.resolveWriter();
        if (writer == null) {
            this.throwWriterNotFoundException();
        }
        return writer;
    }

    protected abstract MessageBodyWriter resolveWriter();

    abstract void throwWriterNotFoundException();
}

