/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.installed;

import io.undertow.Handlers;
import io.undertow.Undertow;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.AllowedMethodsHandler;
import io.undertow.server.handlers.GracefulShutdownHandler;
import io.undertow.server.handlers.PathHandler;
import io.undertow.util.Headers;
import io.undertow.util.Methods;
import java.awt.Desktop;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.Deque;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.client.jaxrs.ResteasyClient;
import org.jboss.resteasy.client.jaxrs.ResteasyClientBuilder;
import org.keycloak.OAuthErrorException;
import org.keycloak.adapters.KeycloakDeployment;
import org.keycloak.adapters.KeycloakDeploymentBuilder;
import org.keycloak.adapters.ServerRequest;
import org.keycloak.adapters.rotation.AdapterTokenVerifier;
import org.keycloak.common.VerificationException;
import org.keycloak.common.util.Base64Url;
import org.keycloak.common.util.KeycloakUriBuilder;
import org.keycloak.common.util.RandomString;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.AccessTokenResponse;
import org.keycloak.representations.IDToken;

public class KeycloakInstalled {
    private static final String KEYCLOAK_JSON = "META-INF/keycloak.json";
    private KeycloakDeployment deployment;
    private AccessTokenResponse tokenResponse;
    private String tokenString;
    private String idTokenString;
    private IDToken idToken;
    private AccessToken token;
    private String refreshToken;
    private Status status;
    private Locale locale;
    private ResteasyClient resteasyClient;
    Pattern callbackPattern = Pattern.compile("callback\\s*=\\s*\"([^\"]+)\"");
    Pattern paramPattern = Pattern.compile("param=\"([^\"]+)\"\\s+label=\"([^\"]+)\"\\s+mask=(\\S+)");
    Pattern codePattern = Pattern.compile("code=([^&]+)");

    public KeycloakInstalled() {
        InputStream config = Thread.currentThread().getContextClassLoader().getResourceAsStream(KEYCLOAK_JSON);
        this.deployment = KeycloakDeploymentBuilder.build(config);
    }

    public KeycloakInstalled(InputStream config) {
        this.deployment = KeycloakDeploymentBuilder.build(config);
    }

    public KeycloakInstalled(KeycloakDeployment deployment) {
        this.deployment = deployment;
    }

    public void setResteasyClient(ResteasyClient resteasyClient) {
        this.resteasyClient = resteasyClient;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public void login() throws IOException, ServerRequest.HttpFailure, VerificationException, InterruptedException, OAuthErrorException, URISyntaxException {
        if (this.isDesktopSupported()) {
            this.loginDesktop();
        } else {
            this.loginManual();
        }
    }

    public void login(PrintStream printer, Reader reader) throws IOException, ServerRequest.HttpFailure, VerificationException, InterruptedException, OAuthErrorException, URISyntaxException {
        if (this.isDesktopSupported()) {
            this.loginDesktop();
        } else {
            this.loginManual(printer, reader);
        }
    }

    public void logout() throws IOException, InterruptedException, URISyntaxException {
        if (this.status == Status.LOGGED_DESKTOP) {
            this.logoutDesktop();
        }
        this.tokenString = null;
        this.token = null;
        this.idTokenString = null;
        this.idToken = null;
        this.refreshToken = null;
        this.status = null;
    }

    public void loginDesktop() throws IOException, VerificationException, OAuthErrorException, URISyntaxException, ServerRequest.HttpFailure, InterruptedException {
        CallbackListener callback = new CallbackListener();
        callback.start();
        String redirectUri = "http://localhost:" + callback.getLocalPort();
        String state = UUID.randomUUID().toString();
        Pkce pkce = this.deployment.isPkce() ? this.generatePkce() : null;
        String authUrl = this.createAuthUrl(redirectUri, state, pkce);
        Desktop.getDesktop().browse(new URI(authUrl));
        try {
            callback.await();
        }
        catch (InterruptedException e) {
            callback.stop();
            throw e;
        }
        if (callback.error != null) {
            throw new OAuthErrorException(callback.error, callback.errorDescription);
        }
        if (!state.equals(callback.state)) {
            throw new VerificationException("Invalid state");
        }
        this.processCode(callback.code, redirectUri, pkce);
        this.status = Status.LOGGED_DESKTOP;
    }

    protected String createAuthUrl(String redirectUri, String state, Pkce pkce) {
        KeycloakUriBuilder builder = this.deployment.getAuthUrl().clone().queryParam("response_type", "code").queryParam("client_id", this.deployment.getResourceName()).queryParam("redirect_uri", redirectUri).queryParam("scope", "openid");
        if (state != null) {
            builder.queryParam("state", state);
        }
        if (this.locale != null) {
            builder.queryParam("ui_locales", this.locale.getLanguage());
        }
        if (pkce != null) {
            builder.queryParam("code_challenge", pkce.getCodeChallenge());
            builder.queryParam("code_challenge_method", "S256");
        }
        return builder.build(new Object[0]).toString();
    }

    protected Pkce generatePkce() {
        return Pkce.generatePkce();
    }

    private void logoutDesktop() throws IOException, URISyntaxException, InterruptedException {
        CallbackListener callback = new CallbackListener();
        callback.start();
        String redirectUri = "http://localhost:" + callback.getLocalPort();
        String logoutUrl = this.deployment.getLogoutUrl().queryParam("redirect_uri", redirectUri).build(new Object[0]).toString();
        Desktop.getDesktop().browse(new URI(logoutUrl));
        try {
            callback.await();
        }
        catch (InterruptedException e) {
            callback.stop();
            throw e;
        }
    }

    public void loginManual() throws IOException, ServerRequest.HttpFailure, VerificationException {
        this.loginManual(System.out, new InputStreamReader(System.in));
    }

    public void loginManual(PrintStream printer, Reader reader) throws IOException, ServerRequest.HttpFailure, VerificationException {
        String redirectUri = "urn:ietf:wg:oauth:2.0:oob";
        Pkce pkce = this.generatePkce();
        String authUrl = this.createAuthUrl(redirectUri, null, pkce);
        printer.println("Open the following URL in a browser. After login copy/paste the code back and press <enter>");
        printer.println(authUrl);
        printer.println();
        printer.print("Code: ");
        String code = this.readCode(reader);
        this.processCode(code, redirectUri, pkce);
        this.status = Status.LOGGED_MANUAL;
    }

    public static Console console() {
        return Console.SINGLETON;
    }

    public boolean loginCommandLine() throws IOException, ServerRequest.HttpFailure, VerificationException {
        String redirectUri = "urn:ietf:wg:oauth:2.0:oob";
        return this.loginCommandLine(redirectUri);
    }

    public boolean loginCommandLine(String redirectUri) throws IOException, ServerRequest.HttpFailure, VerificationException {
        String authUrl = this.deployment.getAuthUrl().clone().queryParam("response_type", "code").queryParam("client_id", this.deployment.getResourceName()).queryParam("redirect_uri", redirectUri).queryParam("display", "console").queryParam("scope", "openid").build(new Object[0]).toString();
        try (ResteasyClient client = this.createResteasyClient();){
            Response response = client.target(authUrl).request().get();
            while (true) {
                if (response.getStatus() == 403) {
                    if (response.getMediaType() != null) {
                        String splash = response.readEntity(String.class);
                        KeycloakInstalled.console().writer().println(splash);
                    } else {
                        System.err.println("Forbidden to login");
                    }
                    boolean splash = false;
                    return splash;
                }
                if (response.getStatus() == 401) {
                    String authenticationHeader = response.getHeaderString("WWW-Authenticate");
                    if (authenticationHeader == null) {
                        System.err.println("Failure:  Invalid protocol.  No WWW-Authenticate header");
                        boolean bl = false;
                        return bl;
                    }
                    if (!authenticationHeader.contains("X-Text-Form-Challenge")) {
                        System.err.println("Failure:  Invalid WWW-Authenticate header.");
                        boolean bl = false;
                        return bl;
                    }
                    if (response.getMediaType() != null) {
                        String splash = response.readEntity(String.class);
                        KeycloakInstalled.console().writer().println(splash);
                    } else {
                        response.close();
                    }
                    Matcher m = this.callbackPattern.matcher(authenticationHeader);
                    if (!m.find()) {
                        System.err.println("Failure: Invalid WWW-Authenticate header.");
                        boolean bl = false;
                        return bl;
                    }
                    String callback = m.group(1);
                    m = this.paramPattern.matcher(authenticationHeader);
                    Form form = new Form();
                    while (m.find()) {
                        String param = m.group(1);
                        String label = m.group(2);
                        String mask = m.group(3).trim();
                        boolean maskInput = mask.equals("true");
                        String value = null;
                        if (maskInput) {
                            char[] txt = KeycloakInstalled.console().readPassword(label, new Object[0]);
                            value = new String(txt);
                        } else {
                            value = KeycloakInstalled.console().readLine(label, new Object[0]);
                        }
                        form.param(param, value);
                    }
                    response.close();
                    client.close();
                    client = this.createResteasyClient();
                    response = client.target(callback).request().post(Entity.form(form));
                    continue;
                }
                if (response.getStatus() != 302) break;
                int redirectCount = 0;
                do {
                    String location;
                    Matcher m;
                    if ((m = this.codePattern.matcher(location = response.getLocation().toString())).find()) {
                        response.close();
                        client.close();
                        String code = m.group(1);
                        this.processCode(code, redirectUri, null);
                        boolean bl = true;
                        return bl;
                    }
                    response.close();
                    client.close();
                    client = this.createResteasyClient();
                    response = client.target(location).request().get();
                    if (response.getStatus() != 302 || redirectCount++ <= 4) continue;
                    System.err.println("Too many redirects.  Aborting");
                    boolean bl = false;
                    return bl;
                } while (response.getStatus() == 302);
            }
            System.err.println("Unknown response from server: " + response.getStatus());
            boolean bl = false;
            return bl;
        }
    }

    protected ResteasyClient getResteasyClient() {
        if (this.resteasyClient == null) {
            this.resteasyClient = this.createResteasyClient();
        }
        return this.resteasyClient;
    }

    protected ResteasyClient createResteasyClient() {
        return new ResteasyClientBuilder().connectionCheckoutTimeout(1L, TimeUnit.HOURS).connectionTTL(1L, TimeUnit.HOURS).socketTimeout(1L, TimeUnit.HOURS).disableTrustManager().build();
    }

    public String getTokenString() {
        return this.tokenString;
    }

    public String getTokenString(long minValidity, TimeUnit unit) throws VerificationException, IOException, ServerRequest.HttpFailure {
        long expires = (long)this.token.getExpiration() * 1000L - unit.toMillis(minValidity);
        if (expires < System.currentTimeMillis()) {
            this.refreshToken();
        }
        return this.tokenString;
    }

    public void refreshToken() throws IOException, ServerRequest.HttpFailure, VerificationException {
        AccessTokenResponse tokenResponse = ServerRequest.invokeRefresh(this.deployment, this.refreshToken);
        this.parseAccessToken(tokenResponse);
    }

    public void refreshToken(String refreshToken) throws IOException, ServerRequest.HttpFailure, VerificationException {
        AccessTokenResponse tokenResponse = ServerRequest.invokeRefresh(this.deployment, refreshToken);
        this.parseAccessToken(tokenResponse);
    }

    private void parseAccessToken(AccessTokenResponse tokenResponse) throws VerificationException {
        this.tokenResponse = tokenResponse;
        this.tokenString = tokenResponse.getToken();
        this.refreshToken = tokenResponse.getRefreshToken();
        this.idTokenString = tokenResponse.getIdToken();
        AdapterTokenVerifier.VerifiedTokens tokens = AdapterTokenVerifier.verifyTokens(this.tokenString, this.idTokenString, this.deployment);
        this.token = tokens.getAccessToken();
        this.idToken = tokens.getIdToken();
    }

    public AccessToken getToken() {
        return this.token;
    }

    public IDToken getIdToken() {
        return this.idToken;
    }

    public String getIdTokenString() {
        return this.idTokenString;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public AccessTokenResponse getTokenResponse() {
        return this.tokenResponse;
    }

    public boolean isDesktopSupported() {
        return Desktop.isDesktopSupported();
    }

    public KeycloakDeployment getDeployment() {
        return this.deployment;
    }

    private void processCode(String code, String redirectUri, Pkce pkce) throws IOException, ServerRequest.HttpFailure, VerificationException {
        AccessTokenResponse tokenResponse = ServerRequest.invokeAccessCodeToToken(this.deployment, code, redirectUri, null, pkce == null ? null : pkce.getCodeVerifier());
        this.parseAccessToken(tokenResponse);
    }

    private String readCode(Reader reader) throws IOException {
        char c;
        StringBuilder sb = new StringBuilder();
        char[] cb = new char[1];
        while (reader.read(cb) != -1 && (c = cb[0]) != ' ' && c != '\n' && c != '\r') {
            sb.append(c);
        }
        return sb.toString();
    }

    public static class Pkce {
        public static final int PKCE_CODE_VERIFIER_MAX_LENGTH = 128;
        private final String codeChallenge;
        private final String codeVerifier;

        public Pkce(String codeVerifier, String codeChallenge) {
            this.codeChallenge = codeChallenge;
            this.codeVerifier = codeVerifier;
        }

        public String getCodeChallenge() {
            return this.codeChallenge;
        }

        public String getCodeVerifier() {
            return this.codeVerifier;
        }

        public static Pkce generatePkce() {
            try {
                String codeVerifier = new RandomString(128, new SecureRandom()).nextString();
                String codeChallenge = Pkce.generateS256CodeChallenge(codeVerifier);
                return new Pkce(codeVerifier, codeChallenge);
            }
            catch (Exception ex) {
                throw new RuntimeException("Could not generate PKCE", ex);
            }
        }

        private static String generateS256CodeChallenge(String codeVerifier) throws Exception {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            md.update(codeVerifier.getBytes(StandardCharsets.ISO_8859_1));
            return Base64Url.encode(md.digest());
        }
    }

    class CallbackListener
    implements HttpHandler {
        private final CountDownLatch shutdownSignal = new CountDownLatch(1);
        private String code;
        private String error;
        private String errorDescription;
        private String state;
        private Undertow server;
        private GracefulShutdownHandler gracefulShutdownHandler;

        CallbackListener() {
        }

        public void start() {
            PathHandler pathHandler = Handlers.path().addExactPath("/", this);
            AllowedMethodsHandler allowedMethodsHandler = new AllowedMethodsHandler((HttpHandler)pathHandler, Methods.GET);
            this.gracefulShutdownHandler = Handlers.gracefulShutdown(allowedMethodsHandler);
            this.server = Undertow.builder().setIoThreads(1).setWorkerThreads(1).addHttpListener(0, "localhost").setHandler(this.gracefulShutdownHandler).build();
            this.server.start();
        }

        public void stop() {
            try {
                this.server.stop();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public int getLocalPort() {
            return ((InetSocketAddress)this.server.getListenerInfo().get(0).getAddress()).getPort();
        }

        public void await() throws InterruptedException {
            this.shutdownSignal.await();
        }

        @Override
        public void handleRequest(HttpServerExchange exchange) throws Exception {
            this.gracefulShutdownHandler.shutdown();
            if (!exchange.getQueryParameters().isEmpty()) {
                this.readQueryParameters(exchange);
            }
            exchange.setStatusCode(302);
            exchange.getResponseHeaders().add(Headers.LOCATION, this.getRedirectUrl());
            exchange.endExchange();
            this.shutdownSignal.countDown();
            ForkJoinPool.commonPool().execute(this::stop);
        }

        private void readQueryParameters(HttpServerExchange exchange) {
            this.code = this.getQueryParameterIfPresent(exchange, "code");
            this.error = this.getQueryParameterIfPresent(exchange, "error");
            this.errorDescription = this.getQueryParameterIfPresent(exchange, "error_description");
            this.state = this.getQueryParameterIfPresent(exchange, "state");
        }

        private String getQueryParameterIfPresent(HttpServerExchange exchange, String name) {
            Map<String, Deque<String>> queryParameters = exchange.getQueryParameters();
            return queryParameters.containsKey(name) ? queryParameters.get(name).getFirst() : null;
        }

        private String getRedirectUrl() {
            String redirectUrl = KeycloakInstalled.this.deployment.getTokenUrl().replace("/token", "/delegated");
            if (this.error != null) {
                redirectUrl = redirectUrl + "?error=true";
            }
            return redirectUrl;
        }
    }

    public static class Console {
        protected java.io.Console console = System.console();
        protected PrintWriter writer;
        protected BufferedReader reader;
        static Console SINGLETON = new Console();

        private Console() {
        }

        public PrintWriter writer() {
            if (this.console == null) {
                if (this.writer == null) {
                    this.writer = new PrintWriter(System.err, true);
                }
                return this.writer;
            }
            return this.console.writer();
        }

        public Reader reader() {
            if (this.console == null) {
                return this.getReader();
            }
            return this.console.reader();
        }

        protected BufferedReader getReader() {
            if (this.reader != null) {
                return this.reader;
            }
            this.reader = new BufferedReader(new BufferedReader(new InputStreamReader(System.in)));
            return this.reader;
        }

        public Console format(String fmt, Object ... args) {
            if (this.console == null) {
                this.writer().format(fmt, args);
                return this;
            }
            this.console.format(fmt, args);
            return this;
        }

        public Console printf(String format, Object ... args) {
            if (this.console == null) {
                this.writer().printf(format, args);
                return this;
            }
            this.console.printf(format, args);
            return this;
        }

        public String readLine(String fmt, Object ... args) {
            if (this.console == null) {
                this.format(fmt, args);
                return this.readLine();
            }
            return this.console.readLine(fmt, args);
        }

        public boolean confirm(String fmt, Object ... args) {
            String prompt = "";
            while (!"y".equals(prompt) && !"n".equals(prompt)) {
                prompt = this.readLine(fmt, args);
            }
            return "y".equals(prompt);
        }

        public String prompt(String fmt, Object ... args) {
            String prompt = "";
            while (prompt.equals("")) {
                prompt = this.readLine(fmt, args).trim();
            }
            return prompt;
        }

        public String passwordPrompt(String fmt, Object ... args) {
            String prompt = "";
            while (prompt.equals("")) {
                char[] val = this.readPassword(fmt, args);
                prompt = new String(val);
                prompt = prompt.trim();
            }
            return prompt;
        }

        public String readLine() {
            if (this.console == null) {
                try {
                    return this.getReader().readLine();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            return this.console.readLine();
        }

        public char[] readPassword(String fmt, Object ... args) {
            if (this.console == null) {
                return this.readLine(fmt, args).toCharArray();
            }
            return this.console.readPassword(fmt, args);
        }

        public char[] readPassword() {
            if (this.console == null) {
                return this.readLine().toCharArray();
            }
            return this.console.readPassword();
        }

        public void flush() {
            if (this.console == null) {
                System.err.flush();
                return;
            }
            this.console.flush();
        }

        public void stderrOutput() {
            this.console = null;
        }
    }

    private static enum Status {
        LOGGED_MANUAL,
        LOGGED_DESKTOP;

    }
}

