/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.client.jaxrs.internal.proxy;

import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import javax.ws.rs.Path;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.RxInvokerProvider;
import javax.ws.rs.client.SyncInvoker;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.container.DynamicFeature;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MediaType;
import org.jboss.resteasy.client.jaxrs.ProxyConfig;
import org.jboss.resteasy.client.jaxrs.ResteasyWebTarget;
import org.jboss.resteasy.client.jaxrs.internal.ClientConfiguration;
import org.jboss.resteasy.client.jaxrs.internal.ClientInvocation;
import org.jboss.resteasy.client.jaxrs.internal.ClientInvocationBuilder;
import org.jboss.resteasy.client.jaxrs.internal.ClientResponse;
import org.jboss.resteasy.client.jaxrs.internal.proxy.MethodInvoker;
import org.jboss.resteasy.client.jaxrs.internal.proxy.extractors.ClientContext;
import org.jboss.resteasy.client.jaxrs.internal.proxy.extractors.DefaultEntityExtractorFactory;
import org.jboss.resteasy.client.jaxrs.internal.proxy.extractors.EntityExtractor;
import org.jboss.resteasy.client.jaxrs.internal.proxy.processors.InvocationProcessor;
import org.jboss.resteasy.client.jaxrs.internal.proxy.processors.ProcessorFactory;
import org.jboss.resteasy.client.jaxrs.internal.proxy.processors.WebTargetProcessor;
import org.jboss.resteasy.util.FeatureContextDelegate;
import org.jboss.resteasy.util.MediaTypeHelper;

public class ClientInvoker
implements MethodInvoker {
    protected String httpMethod;
    protected Method method;
    protected Class<?> declaring;
    protected MediaType accepts;
    protected Object[] processors;
    protected ResteasyWebTarget webTarget;
    protected boolean followRedirects;
    protected EntityExtractor extractor;
    protected DefaultEntityExtractorFactory entityExtractorFactory;
    protected ClientConfiguration invokerConfig;
    protected RxInvokerProvider<?> rxInvokerProvider;
    protected SyncInvoker syncInvoker;

    public ClientInvoker(ResteasyWebTarget parent, Class<?> declaring, Method method, ProxyConfig config) {
        this.webTarget = method.isAnnotationPresent(Path.class) ? parent.path(method) : parent.clone();
        this.declaring = declaring;
        this.method = method;
        this.invokerConfig = (ClientConfiguration)this.webTarget.getConfiguration();
        ResourceInfo info = new ResourceInfo(){

            @Override
            public Method getResourceMethod() {
                return ClientInvoker.this.method;
            }

            @Override
            public Class<?> getResourceClass() {
                return ClientInvoker.this.declaring;
            }
        };
        Set<DynamicFeature> dynamicFeatures = this.invokerConfig.getDynamicFeatures();
        if (null != dynamicFeatures) {
            for (DynamicFeature feature : dynamicFeatures) {
                feature.configure(info, new FeatureContextDelegate(this.invokerConfig));
            }
        }
        this.processors = ProcessorFactory.createProcessors(declaring, method, this.invokerConfig, config.getDefaultConsumes());
        this.accepts = MediaTypeHelper.getProduces(declaring, method, config.getDefaultProduces());
        this.entityExtractorFactory = new DefaultEntityExtractorFactory();
        this.extractor = this.entityExtractorFactory.createExtractor(method);
        this.rxInvokerProvider = this.invokerConfig.getRxInvokerProviderFromReactiveClass(method.getReturnType());
    }

    public MediaType getAccepts() {
        return this.accepts;
    }

    public Method getMethod() {
        return this.method;
    }

    public Class<?> getDeclaring() {
        return this.declaring;
    }

    @Override
    public Object invoke(Object[] args) {
        return this.rxInvokerProvider != null ? this.invokeAsync(args) : this.invokeSync(args);
    }

    protected Object invokeAsync(Object[] args) {
        ClientInvocation request = this.createRequest(args);
        WebTarget t = request.getActualTarget();
        ClientInvocationBuilder builder = (ClientInvocationBuilder)(t != null ? t : this.webTarget).request();
        builder.setInvocation(request);
        ExecutorService executor = this.webTarget.getResteasyClient().getScheduledExecutor();
        if (executor == null) {
            executor = request.asyncInvocationExecutor();
        }
        Object rxInvoker = this.rxInvokerProvider.getRxInvoker(builder, executor);
        Type type = this.method.getGenericReturnType();
        if (type instanceof ParameterizedType) {
            type = ((ParameterizedType)type).getActualTypeArguments()[0];
        }
        GenericType gt = new GenericType(type);
        Object e = request.getEntity();
        Object o = null;
        o = e != null ? rxInvoker.method(this.getHttpMethod(), Entity.entity(e, request.getHeaders().getMediaType()), gt) : rxInvoker.method(this.getHttpMethod(), gt);
        return o;
    }

    protected Object invokeSync(Object[] args) {
        ClientInvocation request = this.createRequest(args);
        ClientResponse response = request.invoke();
        ClientContext context = new ClientContext(request, response, this.entityExtractorFactory);
        return this.extractor.extractEntity(context, new Object[0]);
    }

    protected ClientInvocation createRequest(Object[] args) {
        WebTarget target = this.webTarget;
        for (int i = 0; i < this.processors.length; ++i) {
            if (this.processors == null || !(this.processors[i] instanceof WebTargetProcessor)) continue;
            WebTargetProcessor processor = (WebTargetProcessor)this.processors[i];
            target = processor.build(target, args[i]);
        }
        ClientInvocationBuilder builder = (ClientInvocationBuilder)target.request();
        ClientInvocation clientInvocation = (ClientInvocation)builder.build(this.httpMethod);
        clientInvocation.setClientInvoker(this);
        if (target != this.webTarget) {
            clientInvocation.setActualTarget(target);
        }
        if (this.accepts != null) {
            clientInvocation.getHeaders().accept(this.accepts);
        }
        for (int i = 0; i < this.processors.length; ++i) {
            if (this.processors == null || !(this.processors[i] instanceof InvocationProcessor)) continue;
            InvocationProcessor processor = (InvocationProcessor)this.processors[i];
            processor.process(clientInvocation, args[i]);
        }
        return clientInvocation;
    }

    public String getHttpMethod() {
        return this.httpMethod;
    }

    public void setHttpMethod(String httpMethod) {
        this.httpMethod = httpMethod;
    }

    public boolean isFollowRedirects() {
        return this.followRedirects;
    }

    public void setFollowRedirects(boolean followRedirects) {
        this.followRedirects = followRedirects;
    }

    public void followRedirects() {
        this.setFollowRedirects(true);
    }

    public SyncInvoker getSyncInvoker() {
        return this.syncInvoker;
    }

    public void setSyncInvoker(SyncInvoker syncInvoker) {
        this.syncInvoker = syncInvoker;
    }
}

