/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.microprofile.config;

import java.io.Serializable;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.jboss.resteasy.spi.ResteasyProviderFactory;

public class ServletContextConfigSourceImpl
implements ConfigSource,
Serializable {
    private static final long serialVersionUID = 3280445687403079031L;
    private volatile String name;

    public Map<String, String> getProperties() {
        ServletContext context = ResteasyProviderFactory.getContextData(ServletContext.class);
        if (context == null) {
            return Collections.emptyMap();
        }
        HashMap<String, String> map = new HashMap<String, String>();
        Enumeration keys = context.getInitParameterNames();
        if (keys != null) {
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                map.put(key, context.getInitParameter(key));
            }
        }
        return map;
    }

    public String getValue(String propertyName) {
        ServletContext context = ResteasyProviderFactory.getContextData(ServletContext.class);
        if (context == null) {
            return null;
        }
        return context.getInitParameter(propertyName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getName() {
        if (this.name == null) {
            ServletContextConfigSourceImpl servletContextConfigSourceImpl = this;
            synchronized (servletContextConfigSourceImpl) {
                if (this.name == null) {
                    ServletContext servletContext = ResteasyProviderFactory.getContextData(ServletContext.class);
                    StringBuilder sb = new StringBuilder();
                    this.name = sb.append(servletContext != null ? servletContext.getServletContextName() : null).append(":ServletContextConfigSource").toString();
                }
            }
        }
        return this.name;
    }

    public int getOrdinal() {
        return 40;
    }

    public Set<String> getPropertyNames() {
        return this.getProperties().keySet();
    }
}

