/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.util;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.container.DynamicFeature;
import javax.ws.rs.core.Configurable;
import javax.ws.rs.core.FeatureContext;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import org.jboss.resteasy.resteasy_jaxrs.i18n.LogMessages;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.util.FeatureContextDelegate;

public class DynamicFeatureContextDelegate
extends FeatureContextDelegate {
    public DynamicFeatureContextDelegate(Configurable<?> configurable) {
        super(configurable);
    }

    @Override
    public FeatureContext property(String name, Object value) {
        super.property(name, value);
        return this;
    }

    @Override
    public FeatureContext register(Class<?> componentClass) {
        if (this.checkRegistrability(componentClass, null)) {
            super.register((Class)componentClass);
        }
        return this;
    }

    @Override
    public FeatureContext register(Class<?> componentClass, int priority) {
        if (this.checkRegistrability(componentClass, null)) {
            super.register((Class)componentClass, priority);
        }
        return this;
    }

    @Override
    public FeatureContext register(Class<?> componentClass, Class<?> ... contracts) {
        HashSet contractsSet = new HashSet();
        Collections.addAll(contractsSet, contracts);
        if (this.checkRegistrability(componentClass, contractsSet)) {
            super.register((Class)componentClass, (Class[])contracts);
        }
        return this;
    }

    @Override
    public FeatureContext register(Class<?> componentClass, Map<Class<?>, Integer> contracts) {
        if (this.checkRegistrability(componentClass, contracts == null ? null : contracts.keySet())) {
            super.register((Class)componentClass, (Map)contracts);
        }
        return this;
    }

    @Override
    public FeatureContext register(Object component) {
        if (this.checkRegistrability(component, null)) {
            super.register(component);
        }
        return this;
    }

    @Override
    public FeatureContext register(Object component, int priority) {
        if (this.checkRegistrability(component, null)) {
            super.register(component, priority);
        }
        return this;
    }

    @Override
    public FeatureContext register(Object component, Class<?> ... contracts) {
        HashSet contractsSet = new HashSet();
        Collections.addAll(contractsSet, contracts);
        if (this.checkRegistrability(component, contractsSet)) {
            super.register(component, (Class[])contracts);
        }
        return this;
    }

    @Override
    public FeatureContext register(Object component, Map<Class<?>, Integer> contracts) {
        if (this.checkRegistrability(component, contracts == null ? null : contracts.keySet())) {
            super.register(component, (Map)contracts);
        }
        return this;
    }

    private boolean checkRegistrability(Class<?> componentClass, Set<Class<?>> contracts) {
        if (ResteasyProviderFactory.isA(componentClass, ContextResolver.class, contracts)) {
            LogMessages.LOGGER.providerCantBeDynamicallyBoundToMethod(componentClass, ContextResolver.class);
            return false;
        }
        if (ResteasyProviderFactory.isA(componentClass, ExceptionMapper.class, contracts)) {
            LogMessages.LOGGER.providerCantBeDynamicallyBoundToMethod(componentClass, ExceptionMapper.class);
            return false;
        }
        if (ResteasyProviderFactory.isA(componentClass, MessageBodyWriter.class, contracts)) {
            LogMessages.LOGGER.providerCantBeDynamicallyBoundToMethod(componentClass, MessageBodyWriter.class);
            return false;
        }
        if (ResteasyProviderFactory.isA(componentClass, MessageBodyReader.class, contracts)) {
            LogMessages.LOGGER.providerCantBeDynamicallyBoundToMethod(componentClass, MessageBodyReader.class);
            return false;
        }
        if (ResteasyProviderFactory.isA(componentClass, DynamicFeature.class, contracts)) {
            LogMessages.LOGGER.providerCantBeDynamicallyBoundToMethod(componentClass, DynamicFeature.class);
            return false;
        }
        return true;
    }

    private boolean checkRegistrability(Object component, Set<Class<?>> contracts) {
        if (ResteasyProviderFactory.isA(component, ContextResolver.class, contracts)) {
            LogMessages.LOGGER.providerCantBeDynamicallyBoundToMethod(component.getClass(), ContextResolver.class);
            return false;
        }
        if (ResteasyProviderFactory.isA(component, ExceptionMapper.class, contracts)) {
            LogMessages.LOGGER.providerCantBeDynamicallyBoundToMethod(component.getClass(), ExceptionMapper.class);
            return false;
        }
        if (ResteasyProviderFactory.isA(component, MessageBodyWriter.class, contracts)) {
            LogMessages.LOGGER.providerCantBeDynamicallyBoundToMethod(component.getClass(), MessageBodyWriter.class);
            return false;
        }
        if (ResteasyProviderFactory.isA(component, MessageBodyReader.class, contracts)) {
            LogMessages.LOGGER.providerCantBeDynamicallyBoundToMethod(component.getClass(), MessageBodyReader.class);
            return false;
        }
        if (ResteasyProviderFactory.isA(component, DynamicFeature.class, contracts)) {
            LogMessages.LOGGER.providerCantBeDynamicallyBoundToMethod(component.getClass(), DynamicFeature.class);
            return false;
        }
        return true;
    }
}

