/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.authorization.cip;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.util.EntityUtils;
import org.keycloak.adapters.authorization.ClaimInformationPointProvider;
import org.keycloak.adapters.authorization.PolicyEnforcer;
import org.keycloak.adapters.authorization.util.JsonUtils;
import org.keycloak.adapters.authorization.util.PlaceHolders;
import org.keycloak.adapters.spi.HttpFacade;
import org.keycloak.authorization.client.util.HttpResponseException;
import org.keycloak.common.util.StreamUtil;
import org.keycloak.util.JsonSerialization;

public class HttpClaimInformationPointProvider
implements ClaimInformationPointProvider {
    private final Map<String, Object> config;
    private final HttpClient httpClient;

    public HttpClaimInformationPointProvider(Map<String, Object> config, PolicyEnforcer policyEnforcer) {
        this.config = config;
        this.httpClient = policyEnforcer.getDeployment().getClient();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Map<String, List<String>> resolve(HttpFacade httpFacade) {
        try {
            InputStream responseStream = this.executeRequest(httpFacade);
            try (BufferedInputStream inputStream = new BufferedInputStream(responseStream);){
                JsonNode jsonNode = JsonSerialization.mapper.readTree(inputStream);
                HashMap<String, List<String>> claims = new HashMap<String, List<String>>();
                Map claimsDef = (Map)this.config.get("claims");
                if (claimsDef == null) {
                    Iterator<String> nodeNames = jsonNode.fieldNames();
                    while (nodeNames.hasNext()) {
                        String nodeName = nodeNames.next();
                        claims.put(nodeName, JsonUtils.getValues(jsonNode.get(nodeName)));
                    }
                } else {
                    for (Map.Entry claimDef : claimsDef.entrySet()) {
                        ArrayList<String> jsonPaths = new ArrayList<String>();
                        if (claimDef.getValue() instanceof Collection) {
                            jsonPaths.addAll((Collection)Collection.class.cast(claimDef.getValue()));
                        } else {
                            jsonPaths.add(claimDef.getValue().toString());
                        }
                        ArrayList<String> claimValues = new ArrayList<String>();
                        for (String path : jsonPaths) {
                            claimValues.addAll(JsonUtils.getValues(jsonNode, path));
                        }
                        claims.put((String)claimDef.getKey(), (List<String>)claimValues);
                    }
                }
                HashMap<String, List<String>> hashMap = claims;
                return hashMap;
            }
        }
        catch (IOException cause) {
            throw new RuntimeException("Could not obtain claims from http claim information point [" + this.config.get("url") + "] response", cause);
        }
    }

    private InputStream executeRequest(HttpFacade httpFacade) {
        String method = this.config.get("method").toString();
        if (method == null) {
            method = "GET";
        }
        RequestBuilder builder = null;
        builder = "GET".equalsIgnoreCase(method) ? RequestBuilder.get() : RequestBuilder.post();
        builder.setUri(this.config.get("url").toString());
        byte[] bytes = new byte[]{};
        try {
            StatusLine statusLine;
            int statusCode;
            HttpResponse response;
            HttpEntity entity;
            this.setParameters(builder, httpFacade);
            if (this.config.containsKey("headers")) {
                this.setHeaders(builder, httpFacade);
            }
            if ((entity = (response = this.httpClient.execute(builder.build())).getEntity()) != null) {
                bytes = EntityUtils.toByteArray(entity);
            }
            if ((statusCode = (statusLine = response.getStatusLine()).getStatusCode()) < 200 || statusCode >= 300) {
                throw new HttpResponseException("Unexpected response from server: " + statusCode + " / " + statusLine.getReasonPhrase(), statusCode, statusLine.getReasonPhrase(), bytes);
            }
            return new ByteArrayInputStream(bytes);
        }
        catch (Exception cause) {
            try {
                throw new RuntimeException("Error executing http method [" + builder + "]. Response : " + StreamUtil.readString(new ByteArrayInputStream(bytes), Charset.forName("UTF-8")), cause);
            }
            catch (Exception e) {
                throw new RuntimeException("Error executing http method [" + builder + "]", cause);
            }
        }
    }

    private void setHeaders(RequestBuilder builder, HttpFacade httpFacade) {
        Object headersDef = this.config.get("headers");
        if (headersDef != null) {
            Map headers = (Map)Map.class.cast(headersDef);
            for (Map.Entry header : headers.entrySet()) {
                Object value = header.getValue();
                ArrayList<String> headerValues = new ArrayList<String>();
                if (value instanceof Collection) {
                    Collection values = (Collection)Collection.class.cast(value);
                    for (Object item : values) {
                        headerValues.addAll(PlaceHolders.resolve(item.toString(), httpFacade));
                    }
                } else {
                    headerValues.addAll(PlaceHolders.resolve(value.toString(), httpFacade));
                }
                for (String headerValue : headerValues) {
                    builder.addHeader((String)header.getKey(), headerValue);
                }
            }
        }
    }

    private void setParameters(RequestBuilder builder, HttpFacade httpFacade) {
        Object config = this.config.get("parameters");
        if (config != null) {
            Map paramsDef = (Map)Map.class.cast(config);
            for (Map.Entry paramDef : paramsDef.entrySet()) {
                Object value = paramDef.getValue();
                ArrayList<String> paramValues = new ArrayList<String>();
                if (value instanceof Collection) {
                    Collection values = (Collection)Collection.class.cast(value);
                    for (Object item : values) {
                        paramValues.addAll(PlaceHolders.resolve(item.toString(), httpFacade));
                    }
                } else {
                    paramValues.addAll(PlaceHolders.resolve(value.toString(), httpFacade));
                }
                for (String paramValue : paramValues) {
                    builder.addParameter((String)paramDef.getKey(), paramValue);
                }
            }
        }
    }
}

