/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.common.crypto;

import java.security.InvalidAlgorithmParameterException;
import java.security.KeyFactory;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Signature;
import java.security.cert.CertPathBuilder;
import java.security.cert.CertStore;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CollectionCertStoreParameters;
import java.security.spec.ECParameterSpec;
import java.util.stream.Stream;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKeyFactory;
import org.keycloak.common.crypto.CertificateUtilsProvider;
import org.keycloak.common.crypto.ECDSACryptoProvider;
import org.keycloak.common.crypto.PemUtilsProvider;
import org.keycloak.common.crypto.UserIdentityExtractorProvider;
import org.keycloak.common.util.KeystoreUtil;

public interface CryptoProvider {
    public Provider getBouncyCastleProvider();

    public <T> T getAlgorithmProvider(Class<T> var1, String var2);

    public CertificateUtilsProvider getCertificateUtils();

    public PemUtilsProvider getPemUtils();

    public <T> T getOCSPProver(Class<T> var1);

    public UserIdentityExtractorProvider getIdentityExtractorProvider();

    public ECDSACryptoProvider getEcdsaCryptoProvider();

    public ECParameterSpec createECParams(String var1);

    public KeyPairGenerator getKeyPairGen(String var1) throws NoSuchAlgorithmException, NoSuchProviderException;

    public KeyFactory getKeyFactory(String var1) throws NoSuchAlgorithmException, NoSuchProviderException;

    public Cipher getAesCbcCipher() throws NoSuchAlgorithmException, NoSuchProviderException, NoSuchPaddingException;

    public Cipher getAesGcmCipher() throws NoSuchAlgorithmException, NoSuchProviderException, NoSuchPaddingException;

    public SecretKeyFactory getSecretKeyFact(String var1) throws NoSuchAlgorithmException, NoSuchProviderException;

    public KeyStore getKeyStore(KeystoreUtil.KeystoreFormat var1) throws KeyStoreException, NoSuchProviderException;

    default public Stream<KeystoreUtil.KeystoreFormat> getSupportedKeyStoreTypes() {
        return Stream.of(KeystoreUtil.KeystoreFormat.values()).filter(format -> {
            try {
                this.getKeyStore((KeystoreUtil.KeystoreFormat)((Object)format));
                return true;
            }
            catch (KeyStoreException | NoSuchProviderException ex) {
                return false;
            }
        });
    }

    public CertificateFactory getX509CertFactory() throws CertificateException, NoSuchProviderException;

    public CertStore getCertStore(CollectionCertStoreParameters var1) throws InvalidAlgorithmParameterException, NoSuchAlgorithmException, NoSuchProviderException;

    public CertPathBuilder getCertPathBuilder() throws NoSuchAlgorithmException, NoSuchProviderException;

    public Signature getSignature(String var1) throws NoSuchAlgorithmException, NoSuchProviderException;
}

