/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.representations.idm;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class GroupRepresentation {
    protected String id;
    protected String name;
    protected String path;
    protected String parentId;
    protected Long subGroupCount;
    protected List<GroupRepresentation> subGroups;
    protected Map<String, List<String>> attributes;
    protected List<String> realmRoles;
    protected Map<String, List<String>> clientRoles;
    private Map<String, Boolean> access;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getParentId() {
        return this.parentId;
    }

    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    public Long getSubGroupCount() {
        return this.subGroupCount;
    }

    public void setSubGroupCount(Long subGroupCount) {
        this.subGroupCount = subGroupCount;
    }

    public List<String> getRealmRoles() {
        return this.realmRoles;
    }

    public void setRealmRoles(List<String> realmRoles) {
        this.realmRoles = realmRoles;
    }

    public Map<String, List<String>> getClientRoles() {
        return this.clientRoles;
    }

    public void setClientRoles(Map<String, List<String>> clientRoles) {
        this.clientRoles = clientRoles;
    }

    public Map<String, List<String>> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, List<String>> attributes) {
        this.attributes = attributes;
    }

    public GroupRepresentation singleAttribute(String name, String value) {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, List<String>>();
        }
        this.attributes.put(name, Arrays.asList(value));
        return this;
    }

    public List<GroupRepresentation> getSubGroups() {
        if (this.subGroups == null) {
            this.subGroups = new ArrayList<GroupRepresentation>();
        }
        return this.subGroups;
    }

    public void setSubGroups(List<GroupRepresentation> subGroups) {
        this.subGroups = subGroups;
    }

    public Map<String, Boolean> getAccess() {
        return this.access;
    }

    public void setAccess(Map<String, Boolean> access) {
        this.access = access;
    }

    public void merge(GroupRepresentation g) {
        this.merge(this, g);
    }

    private void merge(GroupRepresentation g1, GroupRepresentation g2) {
        if (g1.equals(g2)) {
            Map<String, GroupRepresentation> g1Children = g1.getSubGroups().stream().collect(Collectors.toMap(GroupRepresentation::getId, g -> g));
            Map<String, GroupRepresentation> g2Children = g2.getSubGroups().stream().collect(Collectors.toMap(GroupRepresentation::getId, g -> g));
            g2Children.forEach((key, value) -> {
                if (g1Children.containsKey(key)) {
                    this.merge((GroupRepresentation)g1Children.get(key), (GroupRepresentation)value);
                } else {
                    g1Children.put((String)key, (GroupRepresentation)value);
                }
            });
            g1.setSubGroups(new ArrayList<GroupRepresentation>(g1Children.values()));
        }
    }

    public boolean equals(Object o) {
        boolean isEqual;
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GroupRepresentation that = (GroupRepresentation)o;
        boolean bl = isEqual = Objects.equals(this.id, that.id) && Objects.equals(this.parentId, that.parentId);
        if (isEqual) {
            return true;
        }
        return Objects.equals(this.name, that.name) && Objects.equals(this.path, that.path);
    }

    public int hashCode() {
        if (this.id == null) {
            return Objects.hash(this.name, this.path);
        }
        return Objects.hash(this.id, this.parentId);
    }
}

