/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.client.registration.cli;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public enum EndpointType {
    DEFAULT("default", "default", new String[0]),
    OIDC("openid-connect", "oidc", "oidc"),
    INSTALL("install", "install", "adapter"),
    SAML2("saml2-entity-descriptor", "saml2", "saml2");

    private String endpoint;
    private String preferredName;
    private Set<String> alternativeNames;

    private EndpointType(String endpoint, String preferredName, String ... alternativeNames) {
        this.endpoint = endpoint;
        this.preferredName = preferredName;
        this.alternativeNames = new HashSet<String>(Arrays.asList(alternativeNames));
    }

    public static EndpointType of(String name) {
        if (EndpointType.DEFAULT.endpoint.equals(name) || EndpointType.DEFAULT.alternativeNames.contains(name)) {
            return DEFAULT;
        }
        if (EndpointType.OIDC.endpoint.equals(name) || EndpointType.OIDC.alternativeNames.contains(name)) {
            return OIDC;
        }
        if (EndpointType.INSTALL.endpoint.equals(name) || EndpointType.INSTALL.alternativeNames.contains(name)) {
            return INSTALL;
        }
        if (EndpointType.SAML2.endpoint.equals(name) || EndpointType.SAML2.alternativeNames.contains(name)) {
            return SAML2;
        }
        throw new IllegalArgumentException("Endpoint not supported: " + name);
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public String getName() {
        return this.preferredName;
    }

    public static String getExpectedContentType(EndpointType type) {
        switch (type) {
            case DEFAULT: 
            case OIDC: {
                return "application/json";
            }
            case SAML2: {
                return "application/xml";
            }
        }
        throw new RuntimeException("Unsupported endpoint type: " + type);
    }
}

