/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.admin.client.resource;

import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.util.List;
import java.util.Map;
import org.keycloak.representations.idm.IdentityProviderMapperRepresentation;
import org.keycloak.representations.idm.IdentityProviderMapperTypeRepresentation;
import org.keycloak.representations.idm.IdentityProviderRepresentation;

public interface IdentityProviderResource {
    @GET
    @Produces(value={"application/json"})
    public IdentityProviderRepresentation toRepresentation();

    @PUT
    @Consumes(value={"application/json"})
    public void update(IdentityProviderRepresentation var1);

    @DELETE
    public void remove();

    @GET
    @Path(value="export")
    public Response export(@QueryParam(value="format") String var1);

    @GET
    @Path(value="mapper-types")
    @Produces(value={"application/json"})
    public Map<String, IdentityProviderMapperTypeRepresentation> getMapperTypes();

    @GET
    @Path(value="mappers")
    @Produces(value={"application/json"})
    public List<IdentityProviderMapperRepresentation> getMappers();

    @POST
    @Path(value="mappers")
    @Consumes(value={"application/json"})
    public Response addMapper(IdentityProviderMapperRepresentation var1);

    @GET
    @Path(value="mappers/{id}")
    @Produces(value={"application/json"})
    public IdentityProviderMapperRepresentation getMapperById(@PathParam(value="id") String var1);

    @PUT
    @Path(value="mappers/{id}")
    @Consumes(value={"application/json"})
    public void update(@PathParam(value="id") String var1, IdentityProviderMapperRepresentation var2);

    @DELETE
    @Path(value="mappers/{id}")
    public void delete(@PathParam(value="id") String var1);
}

