/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.as7;

import java.io.IOException;
import java.security.Principal;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.HashSet;
import javax.security.auth.login.LoginException;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.connector.Request;
import org.jboss.logging.Logger;
import org.keycloak.RSATokenVerifier;
import org.keycloak.SkeletonKeyPrincipal;
import org.keycloak.SkeletonKeySession;
import org.keycloak.VerificationException;
import org.keycloak.adapters.ResourceMetadata;
import org.keycloak.adapters.as7.CatalinaSecurityContextHelper;
import org.keycloak.representations.SkeletonKeyToken;

public class CatalinaBearerTokenAuthenticator {
    protected ResourceMetadata resourceMetadata;
    protected boolean challenge;
    protected Logger log = Logger.getLogger(CatalinaBearerTokenAuthenticator.class);
    protected String tokenString;
    protected SkeletonKeyToken token;
    private Principal principal;
    protected boolean useResourceRoleMappings;

    public CatalinaBearerTokenAuthenticator(ResourceMetadata resourceMetadata, boolean challenge, boolean useResourceRoleMappings) {
        this.resourceMetadata = resourceMetadata;
        this.challenge = challenge;
        this.useResourceRoleMappings = useResourceRoleMappings;
    }

    public ResourceMetadata getResourceMetadata() {
        return this.resourceMetadata;
    }

    public String getTokenString() {
        return this.tokenString;
    }

    public SkeletonKeyToken getToken() {
        return this.token;
    }

    public Principal getPrincipal() {
        return this.principal;
    }

    public boolean login(Request request, HttpServletResponse response) throws LoginException, IOException {
        SkeletonKeyToken.Access access;
        String authHeader = request.getHeader("Authorization");
        if (authHeader == null) {
            if (this.challenge) {
                this.challengeResponse(response, null, null);
                return false;
            }
            return false;
        }
        String[] split = authHeader.trim().split("\\s+");
        if (split == null || split.length != 2) {
            this.challengeResponse(response, null, null);
        }
        if (!split[0].equalsIgnoreCase("Bearer")) {
            this.challengeResponse(response, null, null);
        }
        this.tokenString = split[1];
        try {
            this.token = RSATokenVerifier.verifyToken((String)this.tokenString, (PublicKey)this.resourceMetadata.getRealmKey(), (String)this.resourceMetadata.getRealm());
        }
        catch (VerificationException e) {
            this.log.error((Object)"Failed to verify token", (Throwable)e);
            this.challengeResponse(response, "invalid_token", e.getMessage());
        }
        boolean verifyCaller = false;
        HashSet<String> roles = new HashSet();
        if (this.useResourceRoleMappings) {
            access = this.token.getResourceAccess(this.resourceMetadata.getResourceName());
            if (access != null) {
                roles = access.getRoles();
            }
            verifyCaller = this.token.isVerifyCaller(this.resourceMetadata.getResourceName());
        } else {
            verifyCaller = this.token.isVerifyCaller();
            access = this.token.getRealmAccess();
            if (access != null) {
                roles = access.getRoles();
            }
        }
        String surrogate = null;
        if (verifyCaller) {
            if (this.token.getTrustedCertificates() == null || this.token.getTrustedCertificates().size() == 0) {
                response.sendError(400);
                throw new LoginException("No trusted certificates in token");
            }
            X509Certificate[] chain = request.getCertificateChain();
            if (chain == null || chain.length == 0) {
                response.sendError(400);
                throw new LoginException("No certificates provided by jboss web to verify the caller");
            }
            surrogate = chain[0].getSubjectX500Principal().getName();
        }
        SkeletonKeyPrincipal skeletonKeyPrincipal = new SkeletonKeyPrincipal(this.token.getSubject(), surrogate);
        this.principal = new CatalinaSecurityContextHelper().createPrincipal(request.getContext().getRealm(), (Principal)skeletonKeyPrincipal, roles);
        request.setUserPrincipal(this.principal);
        request.setAuthType("OAUTH_BEARER");
        SkeletonKeySession skSession = new SkeletonKeySession(this.tokenString, this.token, this.resourceMetadata);
        request.setAttribute(SkeletonKeySession.class.getName(), (Object)skSession);
        return true;
    }

    protected void challengeResponse(HttpServletResponse response, String error, String description) throws LoginException {
        StringBuilder header = new StringBuilder("Bearer realm=\"");
        header.append(this.resourceMetadata.getRealm()).append("\"");
        if (error != null) {
            header.append(", error=\"").append(error).append("\"");
        }
        if (description != null) {
            header.append(", error_description=\"").append(description).append("\"");
        }
        response.setHeader("WWW-Authenticate", header.toString());
        try {
            response.sendError(401);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        throw new LoginException("Challenged");
    }
}

