/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.as7;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.Context;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Session;
import org.apache.catalina.Valve;
import org.apache.catalina.authenticator.FormAuthenticator;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.deploy.LoginConfig;
import org.jboss.logging.Logger;
import org.keycloak.KeycloakSecurityContext;
import org.keycloak.adapters.AdapterDeploymentContext;
import org.keycloak.adapters.AuthChallenge;
import org.keycloak.adapters.AuthOutcome;
import org.keycloak.adapters.HttpFacade;
import org.keycloak.adapters.KeycloakDeployment;
import org.keycloak.adapters.KeycloakDeploymentBuilder;
import org.keycloak.adapters.PreAuthActionsHandler;
import org.keycloak.adapters.RefreshableKeycloakSecurityContext;
import org.keycloak.adapters.ServerRequest;
import org.keycloak.adapters.UserSessionManagement;
import org.keycloak.adapters.as7.AuthenticatedActionsValve;
import org.keycloak.adapters.as7.CatalinaHttpFacade;
import org.keycloak.adapters.as7.CatalinaRequestAuthenticator;
import org.keycloak.adapters.as7.CatalinaUserSessionManagement;

public class KeycloakAuthenticatorValve
extends FormAuthenticator
implements LifecycleListener {
    private static final Logger log = Logger.getLogger(KeycloakAuthenticatorValve.class);
    protected CatalinaUserSessionManagement userSessionManagement = new CatalinaUserSessionManagement();
    protected AdapterDeploymentContext deploymentContext;

    public void start() throws LifecycleException {
        super.start();
        StandardContext standardContext = (StandardContext)this.context;
        standardContext.addLifecycleListener((LifecycleListener)this);
        this.cache = false;
    }

    public void logout(Request request) throws ServletException {
        KeycloakSecurityContext ksc = (KeycloakSecurityContext)request.getAttribute(KeycloakSecurityContext.class.getName());
        if (ksc != null) {
            request.removeAttribute(KeycloakSecurityContext.class.getName());
            Session session = request.getSessionInternal(false);
            if (session != null) {
                session.removeNote(KeycloakSecurityContext.class.getName());
                try {
                    ServerRequest.invokeLogout((KeycloakDeployment)this.deploymentContext.getDeployment(), (String)ksc.getToken().getSessionState());
                }
                catch (Exception e) {
                    log.error((Object)"failed to invoke remote logout", (Throwable)e);
                }
            }
        }
        super.logout(request);
    }

    public void lifecycleEvent(LifecycleEvent event) {
        if (event.getType() == "after_start") {
            this.init();
        }
    }

    private static InputStream getJSONFromServletContext(ServletContext servletContext) {
        String json = servletContext.getInitParameter("org.keycloak.json.adapterConfig");
        if (json == null) {
            return null;
        }
        log.info((Object)"**** using org.keycloak.json.adapterConfig");
        log.info((Object)json);
        return new ByteArrayInputStream(json.getBytes());
    }

    private static InputStream getConfigInputStream(Context context) {
        InputStream is = KeycloakAuthenticatorValve.getJSONFromServletContext(context.getServletContext());
        if (is == null) {
            String path = context.getServletContext().getInitParameter("keycloak.config.file");
            if (path == null) {
                log.info((Object)"**** using /WEB-INF/keycloak.json");
                is = context.getServletContext().getResourceAsStream("/WEB-INF/keycloak.json");
            } else {
                try {
                    is = new FileInputStream(path);
                }
                catch (FileNotFoundException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return is;
    }

    protected void init() {
        InputStream configInputStream = KeycloakAuthenticatorValve.getConfigInputStream(this.context);
        KeycloakDeployment kd = null;
        if (configInputStream == null) {
            log.warn((Object)"No adapter configuration.  Keycloak is unconfigured and will deny all requests.");
            kd = new KeycloakDeployment();
        } else {
            kd = KeycloakDeploymentBuilder.build((InputStream)configInputStream);
        }
        this.deploymentContext = new AdapterDeploymentContext(kd);
        this.context.getServletContext().setAttribute(AdapterDeploymentContext.class.getName(), (Object)this.deploymentContext);
        AuthenticatedActionsValve actions = new AuthenticatedActionsValve(this.deploymentContext, this.getNext(), this.getContainer(), this.getController());
        this.setNext((Valve)actions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(Request request, Response response) throws IOException, ServletException {
        log.info((Object)"invoke");
        CatalinaHttpFacade facade = new CatalinaHttpFacade(request, (HttpServletResponse)response);
        PreAuthActionsHandler handler = new PreAuthActionsHandler((UserSessionManagement)this.userSessionManagement, this.deploymentContext, (HttpFacade)facade);
        if (handler.handleRequest()) {
            return;
        }
        this.checkKeycloakSession(request, facade);
        super.invoke(request, response);
    }

    public boolean authenticate(Request request, HttpServletResponse response, LoginConfig config) throws IOException {
        log.info((Object)"*** authenticate");
        CatalinaHttpFacade facade = new CatalinaHttpFacade(request, response);
        KeycloakDeployment deployment = this.deploymentContext.resolveDeployment((HttpFacade)facade);
        if (deployment == null || !deployment.isConfigured()) {
            log.info((Object)"*** deployment isn't configured return false");
            return false;
        }
        CatalinaRequestAuthenticator authenticator = new CatalinaRequestAuthenticator(deployment, this, this.userSessionManagement, facade, request);
        AuthOutcome outcome = authenticator.authenticate();
        if (outcome == AuthOutcome.AUTHENTICATED) {
            return !facade.isEnded();
        }
        AuthChallenge challenge = authenticator.getChallenge();
        if (challenge != null) {
            challenge.challenge((HttpFacade)facade);
        }
        return false;
    }

    protected void checkKeycloakSession(Request request, HttpFacade facade) {
        if (request.getSessionInternal(false) == null || request.getSessionInternal().getPrincipal() == null) {
            return;
        }
        RefreshableKeycloakSecurityContext session = (RefreshableKeycloakSecurityContext)request.getSessionInternal().getNote(KeycloakSecurityContext.class.getName());
        if (session == null) {
            return;
        }
        if (session.getDeployment() == null) {
            session.setDeployment(this.deploymentContext.resolveDeployment(facade));
        }
        if (session.isActive()) {
            return;
        }
        session.refreshExpiredToken();
        if (session.isActive()) {
            return;
        }
        request.getSessionInternal().removeNote(KeycloakSecurityContext.class.getName());
        request.setUserPrincipal(null);
        request.setAuthType(null);
        request.getSessionInternal().setPrincipal(null);
        request.getSessionInternal().setAuthType(null);
    }

    public void keycloakSaveRequest(Request request) throws IOException {
        this.saveRequest(request, request.getSessionInternal(true));
    }

    public boolean keycloakRestoreRequest(Request request) {
        try {
            return this.restoreRequest(request, request.getSessionInternal());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

