/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.subsystem.server.as7;

import java.util.List;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ModelOnlyWriteAttributeHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.keycloak.subsystem.server.as7.KeycloakAdapterConfigService;
import org.keycloak.subsystem.server.as7.KeycloakSubsystemDefinition;
import org.keycloak.subsystem.server.as7.ServerUtil;

public class KeycloakSubsystemWriteAttributeHandler
extends ModelOnlyWriteAttributeHandler {
    public KeycloakSubsystemWriteAttributeHandler(List<SimpleAttributeDefinition> definitions) {
        this(definitions.toArray(new AttributeDefinition[definitions.size()]));
    }

    public KeycloakSubsystemWriteAttributeHandler(AttributeDefinition ... definitions) {
        super(definitions);
    }

    protected void finishModelStage(OperationContext context, ModelNode operation, String attributeName, ModelNode newValue, ModelNode oldValue, Resource model) throws OperationFailedException {
        if (!context.isNormalServer() || this.attribNotChanging(attributeName, newValue, oldValue)) {
            super.finishModelStage(context, operation, attributeName, newValue, oldValue, model);
            return;
        }
        String deploymentName = ServerUtil.getDeploymentName(operation);
        if (attributeName.equals(KeycloakSubsystemDefinition.WEB_CONTEXT.getName())) {
            KeycloakAdapterConfigService.INSTANCE.setWebContext(newValue.asString());
            ServerUtil.addStepToRedeployServerWar(context, deploymentName);
        }
        super.finishModelStage(context, operation, attributeName, newValue, oldValue, model);
    }

    private boolean attribNotChanging(String attributeName, ModelNode newValue, ModelNode oldValue) {
        SimpleAttributeDefinition attribDef = KeycloakSubsystemDefinition.lookup(attributeName);
        if (!oldValue.isDefined()) {
            oldValue = attribDef.getDefaultValue();
        }
        if (!newValue.isDefined()) {
            newValue = attribDef.getDefaultValue();
        }
        return newValue.equals(oldValue);
    }
}

