/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.audit.tests;

import java.util.HashMap;
import java.util.ServiceLoader;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.keycloak.Config;
import org.keycloak.audit.AuditProvider;
import org.keycloak.audit.AuditProviderFactory;
import org.keycloak.audit.Event;
import org.keycloak.audit.EventType;
import org.keycloak.provider.ProviderFactory;

public abstract class AbstractAuditProviderTest {
    private ProviderFactory<AuditProvider> factory;
    private AuditProvider provider;

    @Before
    public void before() {
        String providerId = this.getProviderId();
        ServiceLoader<AuditProviderFactory> factories = ServiceLoader.load(AuditProviderFactory.class);
        for (AuditProviderFactory f : factories) {
            if (!f.getId().equals(providerId)) continue;
            this.factory = f;
            this.factory.init(Config.scope((String[])new String[]{"audit", providerId}));
        }
        this.provider = (AuditProvider)this.factory.create(null);
    }

    protected abstract String getProviderId();

    @After
    public void after() {
        this.provider.clear();
        this.provider.close();
        this.factory.close();
    }

    @Test
    public void save() {
        this.provider.onEvent(this.create(EventType.LOGIN, "realmId", "clientId", "userId", "127.0.0.1", "error"));
    }

    @Test
    public void query() {
        long oldest = System.currentTimeMillis() - 30000L;
        long newest = System.currentTimeMillis() + 30000L;
        this.provider.onEvent(this.create(EventType.LOGIN, "realmId", "clientId", "userId", "127.0.0.1", "error"));
        this.provider.onEvent(this.create(newest, EventType.REGISTER, "realmId", "clientId", "userId", "127.0.0.1", "error"));
        this.provider.onEvent(this.create(newest, EventType.REGISTER, "realmId", "clientId", "userId2", "127.0.0.1", "error"));
        this.provider.onEvent(this.create(EventType.LOGIN, "realmId2", "clientId", "userId", "127.0.0.1", "error"));
        this.provider.onEvent(this.create(oldest, EventType.LOGIN, "realmId", "clientId2", "userId", "127.0.0.1", "error"));
        this.provider.onEvent(this.create(EventType.LOGIN, "realmId", "clientId", "userId2", "127.0.0.1", "error"));
        this.provider.close();
        this.provider = (AuditProvider)this.factory.create(null);
        Assert.assertEquals((long)5L, (long)this.provider.createQuery().client("clientId").getResultList().size());
        Assert.assertEquals((long)5L, (long)this.provider.createQuery().realm("realmId").getResultList().size());
        Assert.assertEquals((long)4L, (long)this.provider.createQuery().event(new EventType[]{EventType.LOGIN}).getResultList().size());
        Assert.assertEquals((long)6L, (long)this.provider.createQuery().event(new EventType[]{EventType.LOGIN, EventType.REGISTER}).getResultList().size());
        Assert.assertEquals((long)4L, (long)this.provider.createQuery().user("userId").getResultList().size());
        Assert.assertEquals((long)1L, (long)this.provider.createQuery().user("userId").event(new EventType[]{EventType.REGISTER}).getResultList().size());
        Assert.assertEquals((long)2L, (long)this.provider.createQuery().maxResults(2).getResultList().size());
        Assert.assertEquals((long)1L, (long)this.provider.createQuery().firstResult(5).getResultList().size());
        Assert.assertEquals((long)newest, (long)((Event)this.provider.createQuery().maxResults(1).getResultList().get(0)).getTime());
        Assert.assertEquals((long)oldest, (long)((Event)this.provider.createQuery().firstResult(5).maxResults(1).getResultList().get(0)).getTime());
    }

    @Test
    public void clear() {
        this.provider.onEvent(this.create(System.currentTimeMillis() - 30000L, EventType.LOGIN, "realmId", "clientId", "userId", "127.0.0.1", "error"));
        this.provider.onEvent(this.create(System.currentTimeMillis() - 20000L, EventType.LOGIN, "realmId", "clientId", "userId", "127.0.0.1", "error"));
        this.provider.onEvent(this.create(System.currentTimeMillis(), EventType.LOGIN, "realmId", "clientId", "userId", "127.0.0.1", "error"));
        this.provider.onEvent(this.create(System.currentTimeMillis(), EventType.LOGIN, "realmId", "clientId", "userId", "127.0.0.1", "error"));
        this.provider.onEvent(this.create(System.currentTimeMillis() - 30000L, EventType.LOGIN, "realmId2", "clientId", "userId", "127.0.0.1", "error"));
        this.provider.close();
        this.provider = (AuditProvider)this.factory.create(null);
        this.provider.clear("realmId");
        Assert.assertEquals((long)1L, (long)this.provider.createQuery().getResultList().size());
    }

    @Test
    public void clearOld() {
        this.provider.onEvent(this.create(System.currentTimeMillis() - 30000L, EventType.LOGIN, "realmId", "clientId", "userId", "127.0.0.1", "error"));
        this.provider.onEvent(this.create(System.currentTimeMillis() - 20000L, EventType.LOGIN, "realmId", "clientId", "userId", "127.0.0.1", "error"));
        this.provider.onEvent(this.create(System.currentTimeMillis(), EventType.LOGIN, "realmId", "clientId", "userId", "127.0.0.1", "error"));
        this.provider.onEvent(this.create(System.currentTimeMillis(), EventType.LOGIN, "realmId", "clientId", "userId", "127.0.0.1", "error"));
        this.provider.onEvent(this.create(System.currentTimeMillis() - 30000L, EventType.LOGIN, "realmId2", "clientId", "userId", "127.0.0.1", "error"));
        this.provider.close();
        this.provider = (AuditProvider)this.factory.create(null);
        this.provider.clear("realmId", System.currentTimeMillis() - 10000L);
        Assert.assertEquals((long)3L, (long)this.provider.createQuery().getResultList().size());
    }

    private Event create(EventType event, String realmId, String clientId, String userId, String ipAddress, String error) {
        return this.create(System.currentTimeMillis(), event, realmId, clientId, userId, ipAddress, error);
    }

    private Event create(long time, EventType event, String realmId, String clientId, String userId, String ipAddress, String error) {
        Event e = new Event();
        e.setTime(time);
        e.setEvent(event);
        e.setRealmId(realmId);
        e.setClientId(clientId);
        e.setUserId(userId);
        e.setIpAddress(ipAddress);
        e.setError(error);
        HashMap<String, String> details = new HashMap<String, String>();
        details.put("key1", "value1");
        details.put("key2", "value2");
        e.setDetails(details);
        return e;
    }
}

