/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.logging.Logger;
import org.keycloak.authentication.AuthProviderStatus;
import org.keycloak.authentication.AuthUser;
import org.keycloak.authentication.AuthenticationProvider;
import org.keycloak.authentication.AuthenticationProviderException;
import org.keycloak.models.AuthenticationLinkModel;
import org.keycloak.models.AuthenticationProviderModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.provider.ProviderSession;

public class AuthenticationProviderManager {
    private static final Logger logger = Logger.getLogger(AuthenticationProviderManager.class);
    private final RealmModel realm;
    private final Map<String, AuthenticationProvider> delegates;

    public static AuthenticationProviderManager getManager(RealmModel realm, ProviderSession providerSession) {
        Set providers = providerSession.getAllProviders(AuthenticationProvider.class);
        HashMap<String, AuthenticationProvider> providersMap = new HashMap<String, AuthenticationProvider>();
        for (AuthenticationProvider provider : providers) {
            providersMap.put(provider.getName(), provider);
        }
        return new AuthenticationProviderManager(realm, providersMap);
    }

    public AuthenticationProviderManager(RealmModel realm, Map<String, AuthenticationProvider> delegates) {
        this.realm = realm;
        this.delegates = delegates;
    }

    public AuthUser getUser(String username) {
        List<AuthenticationProviderModel> authProviderModels = AuthenticationProviderManager.getConfiguredProviderModels(this.realm);
        for (AuthenticationProviderModel providerModel : authProviderModels) {
            AuthenticationProvider delegate = this.getProvider(providerModel.getProviderName());
            if (delegate == null) continue;
            try {
                AuthUser authUser = delegate.getUser(this.realm, providerModel.getConfig(), username);
                if (authUser == null) continue;
                logger.debugf("User '%s' found with provider '%s'", (Object)username, (Object)providerModel.getProviderName());
                return authUser;
            }
            catch (AuthenticationProviderException ape) {
                logger.warn((Object)ape.getMessage(), (Throwable)ape);
            }
        }
        logger.debugf("User '%s' not found with any provider", (Object)username);
        return null;
    }

    public AuthProviderStatus validatePassword(UserModel user, String password) {
        AuthenticationLinkModel authLink = user.getAuthenticationLink();
        if (authLink == null) {
            AuthUser authUser = this.getUser(user.getLoginName());
            authLink = new AuthenticationLinkModel(authUser.getProviderName(), authUser.getId());
            user.setAuthenticationLink(authLink);
            logger.infof("User '%s' linked with provider '%s'", (Object)authUser.getUsername(), (Object)authUser.getProviderName());
        }
        String providerName = authLink.getAuthProvider();
        AuthenticationProviderModel providerModel = AuthenticationProviderManager.getConfiguredProviderModel(this.realm, providerName);
        AuthenticationProvider delegate = this.getProvider(providerName);
        if (delegate == null || providerModel == null) {
            return AuthProviderStatus.FAILED;
        }
        try {
            this.checkCorrectAuthLink(delegate, providerModel, authLink, user.getLoginName());
            AuthProviderStatus currentResult = delegate.validatePassword(this.realm, providerModel.getConfig(), user.getLoginName(), password);
            logger.debugf("Authentication provider '%s' finished with '%s' for authentication of '%s'", (Object)delegate.getName(), (Object)currentResult.toString(), (Object)user.getLoginName());
            return currentResult;
        }
        catch (AuthenticationProviderException ape) {
            logger.warn((Object)ape.getMessage(), (Throwable)ape);
            return AuthProviderStatus.FAILED;
        }
    }

    public boolean updatePassword(UserModel user, String password) throws AuthenticationProviderException {
        String providerName;
        AuthenticationProviderModel providerModel;
        AuthenticationProvider delegate;
        AuthenticationLinkModel authLink = user.getAuthenticationLink();
        if (authLink == null) {
            List<AuthenticationProviderModel> configuredProviders = AuthenticationProviderManager.getConfiguredProviderModels(this.realm);
            for (AuthenticationProviderModel providerModel2 : configuredProviders) {
                if (!providerModel2.isPasswordUpdateSupported() || (delegate = this.getProvider(providerModel2.getProviderName())) == null) continue;
                AuthUser authUser = delegate.getUser(this.realm, providerModel2.getConfig(), user.getLoginName());
                if (authUser != null) {
                    if (providerModel2.getProviderName().equals(AuthenticationProviderModel.DEFAULT_PROVIDER.getProviderName())) {
                        authLink = new AuthenticationLinkModel(providerModel2.getProviderName(), authUser.getId());
                        user.setAuthenticationLink(authLink);
                        logger.infof("User '%s' linked with provider '%s'", (Object)authUser.getUsername(), (Object)authUser.getProviderName());
                        break;
                    }
                    throw new AuthenticationProviderException("User " + authUser.getUsername() + " exists in provider " + authUser.getProviderName() + " but is not linked with model user");
                }
                String userIdInProvider = delegate.registerUser(this.realm, providerModel2.getConfig(), user.getLoginName());
                authLink = new AuthenticationLinkModel(providerModel2.getProviderName(), userIdInProvider);
                user.setAuthenticationLink(authLink);
                logger.infof("User '%s' registered in provider '%s' and linked", (Object)user.getLoginName(), (Object)providerModel2.getProviderName());
                break;
            }
            if (authLink == null) {
                logger.warnf("No providers found where password update is supported for user '%s'", (Object)user.getLoginName());
                return false;
            }
        }
        if ((providerModel = AuthenticationProviderManager.getConfiguredProviderModel(this.realm, providerName = authLink.getAuthProvider())) == null) {
            return false;
        }
        String username = user.getLoginName();
        if (providerModel.isPasswordUpdateSupported()) {
            try {
                delegate = this.getProvider(providerName);
                if (delegate == null) {
                    return false;
                }
                this.checkCorrectAuthLink(delegate, providerModel, authLink, username);
                if (delegate.updateCredential(this.realm, providerModel.getConfig(), user.getLoginName(), password)) {
                    logger.debugf("Updated password in authentication provider '%s' for user '%s'", (Object)providerName, (Object)username);
                    return true;
                }
                logger.warnf("Password not updated in authentication provider '%s' for user '%s'", (Object)providerName, (Object)username);
                return false;
            }
            catch (AuthenticationProviderException ape) {
                logger.warn((Object)("Failed to update password: " + ape.getMessage()));
                throw ape;
            }
        }
        logger.warnf("Skip password update for authentication provider '%s' for user '%s'", (Object)providerName, (Object)username);
        return false;
    }

    private AuthenticationProvider getProvider(String providerName) {
        AuthenticationProvider delegate = this.delegates.get(providerName);
        if (delegate == null) {
            logger.warnf("Provider '%s' not available on classpath", (Object)providerName);
        }
        return delegate;
    }

    private static List<AuthenticationProviderModel> getConfiguredProviderModels(RealmModel realm) {
        List configuredProviders = realm.getAuthenticationProviders();
        if (configuredProviders == null || configuredProviders.isEmpty()) {
            configuredProviders = Collections.EMPTY_LIST;
            logger.warnf("No authentication providers found", new Object[0]);
        }
        return configuredProviders;
    }

    public static AuthenticationProviderModel getConfiguredProviderModel(RealmModel realm, String providerName) {
        List<AuthenticationProviderModel> providers = AuthenticationProviderManager.getConfiguredProviderModels(realm);
        for (AuthenticationProviderModel provider : providers) {
            if (!providerName.equals(provider.getProviderName())) continue;
            return provider;
        }
        logger.warnf("Provider '%s' not configured in realm", (Object)providerName);
        return null;
    }

    private void checkCorrectAuthLink(AuthenticationProvider authProvider, AuthenticationProviderModel providerModel, AuthenticationLinkModel authLinkModel, String username) throws AuthenticationProviderException {
        AuthUser authUser = authProvider.getUser(this.realm, providerModel.getConfig(), username);
        if (authUser == null) {
            throw new AuthenticationProviderException("User " + username + " not found in authentication provider " + providerModel.getProviderName());
        }
        String userExternalId = authUser.getId();
        if (!userExternalId.equals(authLinkModel.getAuthUserId())) {
            throw new AuthenticationProviderException("ID did not match! ID from provider: " + userExternalId + ", ID from authentication link: " + authLinkModel.getAuthUserId());
        }
    }
}

