/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.client.resource;

import java.util.Set;
import org.keycloak.authorization.client.representation.RegistrationResponse;
import org.keycloak.authorization.client.representation.ResourceRepresentation;
import org.keycloak.authorization.client.util.Http;
import org.keycloak.authorization.client.util.Throwables;
import org.keycloak.util.JsonSerialization;

public class ProtectedResource {
    private final Http http;
    private final String pat;

    public ProtectedResource(Http http, String pat) {
        this.http = http;
        this.pat = pat;
    }

    public RegistrationResponse create(ResourceRepresentation resource) {
        try {
            return this.http.post("/authz/protection/resource_set").authorizationBearer(this.pat).json(JsonSerialization.writeValueAsBytes((Object)resource)).response().json(RegistrationResponse.class).execute();
        }
        catch (Exception cause) {
            throw Throwables.handleAndWrapException("Could not create resource", cause);
        }
    }

    public void update(ResourceRepresentation resource) {
        try {
            this.http.put("/authz/protection/resource_set/" + resource.getId()).authorizationBearer(this.pat).json(JsonSerialization.writeValueAsBytes((Object)resource)).execute();
        }
        catch (Exception cause) {
            throw Throwables.handleAndWrapException("Could not update resource", cause);
        }
    }

    public RegistrationResponse findById(String id) {
        try {
            return this.http.get("/authz/protection/resource_set/" + id).authorizationBearer(this.pat).response().json(RegistrationResponse.class).execute();
        }
        catch (Exception cause) {
            throw Throwables.handleAndWrapException("Could not find resource", cause);
        }
    }

    public Set<String> findByFilter(String filter) {
        try {
            return this.http.get("/authz/protection/resource_set").authorizationBearer(this.pat).param("filter", filter).response().json(Set.class).execute();
        }
        catch (Exception cause) {
            throw Throwables.handleAndWrapException("Could not find resource", cause);
        }
    }

    public Set<String> findAll() {
        try {
            return this.http.get("/authz/protection/resource_set").authorizationBearer(this.pat).response().json(Set.class).execute();
        }
        catch (Exception cause) {
            throw Throwables.handleAndWrapException("Could not find resource", cause);
        }
    }

    public void delete(String id) {
        try {
            this.http.delete("/authz/protection/resource_set/" + id).authorizationBearer(this.pat).execute();
        }
        catch (Exception cause) {
            throw Throwables.handleAndWrapException("Could not delete resource", cause);
        }
    }
}

