/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.client.resource;

import com.fasterxml.jackson.core.type.TypeReference;
import java.util.List;
import java.util.concurrent.Callable;
import org.keycloak.authorization.client.Configuration;
import org.keycloak.authorization.client.representation.ServerConfiguration;
import org.keycloak.authorization.client.util.Http;
import org.keycloak.authorization.client.util.HttpMethod;
import org.keycloak.authorization.client.util.Throwables;
import org.keycloak.authorization.client.util.TokenCallable;
import org.keycloak.representations.idm.authorization.ResourceRepresentation;
import org.keycloak.util.JsonSerialization;

public class ProtectedResource {
    private final Http http;
    private ServerConfiguration serverConfiguration;
    private final Configuration configuration;
    private final TokenCallable pat;

    ProtectedResource(Http http, ServerConfiguration serverConfiguration, Configuration configuration, TokenCallable pat) {
        this.http = http;
        this.serverConfiguration = serverConfiguration;
        this.configuration = configuration;
        this.pat = pat;
    }

    public ResourceRepresentation create(final ResourceRepresentation resource) {
        Callable<ResourceRepresentation> callable = new Callable<ResourceRepresentation>(){

            @Override
            public ResourceRepresentation call() throws Exception {
                return ProtectedResource.this.http.post(ProtectedResource.this.serverConfiguration.getResourceRegistrationEndpoint()).authorizationBearer(ProtectedResource.this.pat.call()).json(JsonSerialization.writeValueAsBytes((Object)resource)).response().json(ResourceRepresentation.class).execute();
            }
        };
        try {
            return (ResourceRepresentation)callable.call();
        }
        catch (Exception cause) {
            return Throwables.retryAndWrapExceptionIfNecessary(callable, this.pat, "Could not create resource", cause);
        }
    }

    public void update(final ResourceRepresentation resource) {
        if (resource.getId() == null) {
            throw new IllegalArgumentException("You must provide the resource id");
        }
        Callable callable = new Callable(){

            public Object call() throws Exception {
                ProtectedResource.this.http.put(ProtectedResource.this.serverConfiguration.getResourceRegistrationEndpoint() + "/" + resource.getId()).authorizationBearer(ProtectedResource.this.pat.call()).json(JsonSerialization.writeValueAsBytes((Object)resource)).execute();
                return null;
            }
        };
        try {
            callable.call();
        }
        catch (Exception cause) {
            Throwables.retryAndWrapExceptionIfNecessary(callable, this.pat, "Could not update resource", cause);
        }
    }

    public ResourceRepresentation findById(final String id) {
        Callable<ResourceRepresentation> callable = new Callable<ResourceRepresentation>(){

            @Override
            public ResourceRepresentation call() throws Exception {
                return ProtectedResource.this.http.get(ProtectedResource.this.serverConfiguration.getResourceRegistrationEndpoint() + "/" + id).authorizationBearer(ProtectedResource.this.pat.call()).response().json(ResourceRepresentation.class).execute();
            }
        };
        try {
            return (ResourceRepresentation)callable.call();
        }
        catch (Exception cause) {
            return Throwables.retryAndWrapExceptionIfNecessary(callable, this.pat, "Could not find resource", cause);
        }
    }

    public ResourceRepresentation findByName(String name) {
        List representations = (List)this.find(null, name, null, this.configuration.getResource(), null, null, false, true, null, null);
        if (representations.isEmpty()) {
            return null;
        }
        return (ResourceRepresentation)representations.get(0);
    }

    public ResourceRepresentation findByName(String name, String ownerId) {
        List representations = (List)this.find(null, name, null, ownerId, null, null, false, true, null, null);
        if (representations.isEmpty()) {
            return null;
        }
        return (ResourceRepresentation)representations.get(0);
    }

    public String[] find(final String id, final String name, final String uri, final String owner, final String type, final String scope, final boolean matchingUri, final Integer firstResult, final Integer maxResult) {
        Callable<String[]> callable = new Callable<String[]>(){

            @Override
            public String[] call() throws Exception {
                return ProtectedResource.this.createFindRequest(id, name, uri, owner, type, scope, matchingUri, false, firstResult, maxResult).response().json(String[].class).execute();
            }
        };
        try {
            return (String[])callable.call();
        }
        catch (Exception cause) {
            return Throwables.retryAndWrapExceptionIfNecessary(callable, this.pat, "Could not find resource", cause);
        }
    }

    public <R> R find(final String id, final String name, final String uri, final String owner, final String type, final String scope, final boolean matchingUri, final boolean deep, final Integer firstResult, final Integer maxResult) {
        if (deep) {
            Callable<List<ResourceRepresentation>> callable = new Callable<List<ResourceRepresentation>>(){

                @Override
                public List<ResourceRepresentation> call() {
                    return (List)ProtectedResource.this.createFindRequest(id, name, uri, owner, type, scope, matchingUri, deep, firstResult, maxResult).response().json((TypeReference)new TypeReference<List<ResourceRepresentation>>(){}).execute();
                }
            };
            try {
                return (R)callable.call();
            }
            catch (Exception cause) {
                return (R)Throwables.retryAndWrapExceptionIfNecessary(callable, this.pat, "Could not find resource", cause);
            }
        }
        return (R)this.find(id, name, uri, owner, type, scope, matchingUri, firstResult, maxResult);
    }

    public String[] findAll() {
        try {
            return this.find(null, null, null, null, null, null, false, null, null);
        }
        catch (Exception cause) {
            throw Throwables.handleWrapException("Could not find resource", cause);
        }
    }

    public void delete(final String id) {
        Callable callable = new Callable(){

            public Object call() throws Exception {
                ProtectedResource.this.http.delete(ProtectedResource.this.serverConfiguration.getResourceRegistrationEndpoint() + "/" + id).authorizationBearer(ProtectedResource.this.pat.call()).execute();
                return null;
            }
        };
        try {
            callable.call();
        }
        catch (Exception cause) {
            Throwables.retryAndWrapExceptionIfNecessary(callable, this.pat, "", cause);
        }
    }

    public List<ResourceRepresentation> findByUri(String uri) {
        return (List)this.find(null, null, uri, null, null, null, false, true, null, null);
    }

    public List<ResourceRepresentation> findByMatchingUri(String uri) {
        return (List)this.find(null, null, uri, null, null, null, true, true, null, null);
    }

    private HttpMethod createFindRequest(String id, String name, String uri, String owner, String type, String scope, boolean matchingUri, boolean deep, Integer firstResult, Integer maxResult) {
        return this.http.get(this.serverConfiguration.getResourceRegistrationEndpoint()).authorizationBearer(this.pat.call()).param("_id", id).param("name", name).param("uri", uri).param("owner", owner).param("type", type).param("scope", scope).param("matchingUri", Boolean.valueOf(matchingUri).toString()).param("deep", Boolean.toString(deep)).param("first", firstResult != null ? firstResult.toString() : null).param("max", maxResult != null ? maxResult.toString() : Integer.toString(-1));
    }
}

