/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.policy.provider.role;

import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.identity.Identity;
import org.keycloak.authorization.model.Policy;
import org.keycloak.authorization.policy.evaluation.Evaluation;
import org.keycloak.authorization.policy.evaluation.EvaluationContext;
import org.keycloak.authorization.policy.provider.PolicyProvider;
import org.keycloak.authorization.policy.provider.role.RolePolicyProviderFactory;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;

public class RolePolicyProvider
implements PolicyProvider {
    private final Policy policy;
    private final AuthorizationProvider authorization;

    public RolePolicyProvider(Policy policy, AuthorizationProvider authorization) {
        this.policy = policy;
        this.authorization = authorization;
    }

    public RolePolicyProvider() {
        this(null, null);
    }

    public void evaluate(Evaluation evaluation) {
        EvaluationContext context = evaluation.getContext();
        String[] roleIds = RolePolicyProviderFactory.getRoles(this.policy);
        if (roleIds.length > 0) {
            Identity identity = context.getIdentity();
            for (String roleId : roleIds) {
                RoleModel role = this.getCurrentRealm().getRoleById(roleId);
                if (role == null || !identity.hasRole(role.getName())) continue;
                evaluation.grant();
                break;
            }
        }
    }

    private RealmModel getCurrentRealm() {
        return this.authorization.getKeycloakSession().getContext().getRealm();
    }

    public void close() {
    }
}

