/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.policy.provider.role;

import java.util.Map;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.identity.Identity;
import org.keycloak.authorization.model.Policy;
import org.keycloak.authorization.policy.evaluation.Evaluation;
import org.keycloak.authorization.policy.provider.PolicyProvider;
import org.keycloak.authorization.policy.provider.role.RolePolicyProviderFactory;
import org.keycloak.models.ClientModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;

public class RolePolicyProvider
implements PolicyProvider {
    private final Policy policy;
    private final AuthorizationProvider authorization;

    public RolePolicyProvider(Policy policy, AuthorizationProvider authorization) {
        this.policy = policy;
        this.authorization = authorization;
    }

    public RolePolicyProvider() {
        this(null, null);
    }

    public void evaluate(Evaluation evaluation) {
        Map<String, Object>[] roleIds = RolePolicyProviderFactory.getRoles(this.policy);
        if (roleIds.length > 0) {
            Identity identity = evaluation.getContext().getIdentity();
            for (Map<String, Object> current : roleIds) {
                RoleModel role = this.getCurrentRealm().getRoleById((String)current.get("id"));
                if (role == null) continue;
                boolean hasRole = this.hasRole(identity, role);
                if (!hasRole && Boolean.valueOf(this.isRequired(current)).booleanValue()) {
                    evaluation.deny();
                    return;
                }
                if (!hasRole) continue;
                evaluation.grant();
            }
        }
    }

    private boolean isRequired(Map<String, Object> current) {
        return (Boolean)current.getOrDefault("required", false);
    }

    private boolean hasRole(Identity identity, RoleModel role) {
        String roleName = role.getName();
        if (role.isClientRole()) {
            ClientModel clientModel = this.getCurrentRealm().getClientById(role.getContainerId());
            return identity.hasClientRole(clientModel.getClientId(), roleName);
        }
        return identity.hasRealmRole(roleName);
    }

    private RealmModel getCurrentRealm() {
        return this.authorization.getKeycloakSession().getContext().getRealm();
    }

    public void close() {
    }
}

