/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.policy.provider.role;

import java.util.Map;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.identity.Identity;
import org.keycloak.authorization.model.Policy;
import org.keycloak.authorization.policy.evaluation.Evaluation;
import org.keycloak.authorization.policy.provider.PolicyProvider;
import org.keycloak.authorization.policy.provider.role.RolePolicyProviderFactory;
import org.keycloak.models.ClientModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;

public class RolePolicyProvider
implements PolicyProvider {
    public void evaluate(Evaluation evaluation) {
        Policy policy = evaluation.getPolicy();
        Map<String, Object>[] roleIds = RolePolicyProviderFactory.getRoles(policy);
        AuthorizationProvider authorizationProvider = evaluation.getAuthorizationProvider();
        RealmModel realm = authorizationProvider.getKeycloakSession().getContext().getRealm();
        if (roleIds.length > 0) {
            Identity identity = evaluation.getContext().getIdentity();
            for (Map<String, Object> current : roleIds) {
                RoleModel role = realm.getRoleById((String)current.get("id"));
                if (role == null) continue;
                boolean hasRole = this.hasRole(identity, role, realm);
                if (!hasRole && Boolean.valueOf(this.isRequired(current)).booleanValue()) {
                    evaluation.deny();
                    return;
                }
                if (!hasRole) continue;
                evaluation.grant();
            }
        }
    }

    private boolean isRequired(Map<String, Object> current) {
        return (Boolean)current.getOrDefault("required", false);
    }

    private boolean hasRole(Identity identity, RoleModel role, RealmModel realm) {
        String roleName = role.getName();
        if (role.isClientRole()) {
            ClientModel clientModel = realm.getClientById(role.getContainerId());
            return identity.hasClientRole(clientModel.getClientId(), roleName);
        }
        return identity.hasRealmRole(roleName);
    }

    public void close() {
    }
}

