/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.policy.provider.group;

import java.util.Collection;
import java.util.List;
import java.util.function.BiFunction;
import org.jboss.logging.Logger;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.attribute.Attributes;
import org.keycloak.authorization.model.Policy;
import org.keycloak.authorization.policy.evaluation.Evaluation;
import org.keycloak.authorization.policy.provider.PolicyProvider;
import org.keycloak.models.GroupModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.utils.ModelToRepresentation;
import org.keycloak.representations.idm.authorization.GroupPolicyRepresentation;

public class GroupPolicyProvider
implements PolicyProvider {
    private static final Logger logger = Logger.getLogger(GroupPolicyProvider.class);
    private final BiFunction<Policy, AuthorizationProvider, GroupPolicyRepresentation> representationFunction;

    public GroupPolicyProvider(BiFunction<Policy, AuthorizationProvider, GroupPolicyRepresentation> representationFunction) {
        this.representationFunction = representationFunction;
    }

    public void evaluate(Evaluation evaluation) {
        AuthorizationProvider authorizationProvider = evaluation.getAuthorizationProvider();
        GroupPolicyRepresentation policy = this.representationFunction.apply(evaluation.getPolicy(), authorizationProvider);
        RealmModel realm = authorizationProvider.getRealm();
        Attributes.Entry groupsClaim = evaluation.getContext().getIdentity().getAttributes().getValue(policy.getGroupsClaim());
        if (groupsClaim == null || groupsClaim.isEmpty()) {
            List userGroups = evaluation.getRealm().getUserGroups(evaluation.getContext().getIdentity().getId());
            groupsClaim = new Attributes.Entry(policy.getGroupsClaim(), (Collection)userGroups);
        }
        for (GroupPolicyRepresentation.GroupDefinition definition : policy.getGroups()) {
            GroupModel allowedGroup = realm.getGroupById(definition.getId());
            for (int i = 0; i < groupsClaim.size(); ++i) {
                String allowedGroupPath;
                String group = groupsClaim.asString(i);
                if (group.indexOf(47) != -1 && (group.equals(allowedGroupPath = ModelToRepresentation.buildGroupPath((GroupModel)allowedGroup)) || definition.isExtendChildren() && group.startsWith(allowedGroupPath))) {
                    evaluation.grant();
                    return;
                }
                if (!group.equals(allowedGroup.getName())) continue;
                evaluation.grant();
                return;
            }
        }
        logger.debugv("Groups policy {} evaluated to {} with identity groups {}", (Object)policy.getName(), (Object)evaluation.getEffect(), (Object)groupsClaim);
    }

    public void close() {
    }
}

