/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.policy.provider.user;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.keycloak.Config;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.model.Policy;
import org.keycloak.authorization.policy.provider.PolicyProvider;
import org.keycloak.authorization.policy.provider.PolicyProviderFactory;
import org.keycloak.authorization.policy.provider.user.UserPolicyProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserProvider;
import org.keycloak.representations.idm.authorization.PolicyRepresentation;
import org.keycloak.representations.idm.authorization.UserPolicyRepresentation;
import org.keycloak.util.JsonSerialization;

public class UserPolicyProviderFactory
implements PolicyProviderFactory<UserPolicyRepresentation> {
    private UserPolicyProvider provider = new UserPolicyProvider(this::toRepresentation);

    public String getName() {
        return "User";
    }

    public String getGroup() {
        return "Identity Based";
    }

    public PolicyProvider create(AuthorizationProvider authorization) {
        return this.provider;
    }

    public PolicyProvider create(KeycloakSession session) {
        return null;
    }

    public UserPolicyRepresentation toRepresentation(Policy policy, AuthorizationProvider authorization) {
        UserPolicyRepresentation representation = new UserPolicyRepresentation();
        try {
            String users = (String)policy.getConfig().get("users");
            if (users == null) {
                representation.setUsers(Collections.emptySet());
            } else {
                representation.setUsers(((Set)JsonSerialization.readValue((String)users, Set.class)).stream().filter(id -> UserPolicyProviderFactory.getUser((String)id, authorization) != null).collect(Collectors.toSet()));
            }
        }
        catch (IOException cause) {
            throw new RuntimeException("Failed to deserialize roles", cause);
        }
        return representation;
    }

    public Class<UserPolicyRepresentation> getRepresentationType() {
        return UserPolicyRepresentation.class;
    }

    public void onCreate(Policy policy, UserPolicyRepresentation representation, AuthorizationProvider authorization) {
        this.updateUsers(policy, authorization, representation.getUsers());
    }

    public void onUpdate(Policy policy, UserPolicyRepresentation representation, AuthorizationProvider authorization) {
        this.updateUsers(policy, authorization, representation.getUsers());
    }

    public void onImport(Policy policy, PolicyRepresentation representation, AuthorizationProvider authorization) {
        try {
            this.updateUsers(policy, authorization, (Set)JsonSerialization.readValue((String)((String)representation.getConfig().get("users")), Set.class));
        }
        catch (IOException cause) {
            throw new RuntimeException("Failed to deserialize users during import", cause);
        }
    }

    public void onExport(Policy policy, PolicyRepresentation representation, AuthorizationProvider authorizationProvider) {
        UserPolicyRepresentation userRep = this.toRepresentation(policy, authorizationProvider);
        HashMap<String, String> config = new HashMap<String, String>();
        try {
            UserProvider userProvider = authorizationProvider.getKeycloakSession().users();
            RealmModel realm = authorizationProvider.getRealm();
            config.put("users", JsonSerialization.writeValueAsString(userRep.getUsers().stream().map(id -> {
                UserModel user = userProvider.getUserById(realm, id);
                return user != null ? user.getUsername() : null;
            }).filter(Objects::nonNull).collect(Collectors.toList())));
        }
        catch (IOException cause) {
            throw new RuntimeException("Failed to export user policy [" + policy.getName() + "]", cause);
        }
        representation.setConfig(config);
    }

    private void updateUsers(Policy policy, AuthorizationProvider authorization, Set<String> users) {
        HashSet<String> updatedUsers = new HashSet<String>();
        if (users != null) {
            for (String userId : users) {
                UserModel user = UserPolicyProviderFactory.getUser(userId, authorization);
                if (user == null) {
                    throw new RuntimeException("Error while updating policy [" + policy.getName() + "]. User [" + userId + "] could not be found.");
                }
                updatedUsers.add(user.getId());
            }
        }
        try {
            policy.putConfig("users", JsonSerialization.writeValueAsString(updatedUsers));
        }
        catch (IOException cause) {
            throw new RuntimeException("Failed to serialize users", cause);
        }
    }

    private static UserModel getUser(String userId, AuthorizationProvider authorization) {
        if (userId == null) {
            return null;
        }
        KeycloakSession session = authorization.getKeycloakSession();
        RealmModel realm = authorization.getRealm();
        UserProvider userProvider = session.users();
        UserModel user = userProvider.getUserByUsername(realm, userId);
        if (user == null) {
            user = userProvider.getUserById(realm, userId);
        }
        return user;
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public void close() {
    }

    public String getId() {
        return "user";
    }
}

