/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.policy.provider.aggregated;

import java.util.List;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.Decision;
import org.keycloak.authorization.model.Policy;
import org.keycloak.authorization.policy.evaluation.DecisionResultCollector;
import org.keycloak.authorization.policy.evaluation.DefaultEvaluation;
import org.keycloak.authorization.policy.evaluation.Evaluation;
import org.keycloak.authorization.policy.evaluation.Result;
import org.keycloak.authorization.policy.provider.PolicyProvider;

public class AggregatePolicyProvider
implements PolicyProvider {
    public void evaluate(final Evaluation evaluation) {
        DecisionResultCollector decision = new DecisionResultCollector(){

            protected void onComplete(List<Result> results) {
                if (results.isEmpty()) {
                    evaluation.deny();
                } else {
                    Result result = results.iterator().next();
                    if (Decision.Effect.PERMIT.equals((Object)result.getEffect())) {
                        evaluation.grant();
                    }
                }
            }
        };
        Policy policy = evaluation.getPolicy();
        AuthorizationProvider authorization = evaluation.getAuthorizationProvider();
        policy.getAssociatedPolicies().forEach(associatedPolicy -> {
            PolicyProvider policyProvider = authorization.getProvider(associatedPolicy.getType());
            policyProvider.evaluate((Evaluation)new DefaultEvaluation(evaluation.getPermission(), evaluation.getContext(), policy, associatedPolicy, (Decision)decision, authorization));
        });
        decision.onComplete();
    }

    public void close() {
    }
}

