/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.policy.provider.user;

import java.util.function.Function;
import org.keycloak.authorization.model.Policy;
import org.keycloak.authorization.policy.evaluation.Evaluation;
import org.keycloak.authorization.policy.evaluation.EvaluationContext;
import org.keycloak.authorization.policy.provider.PolicyProvider;
import org.keycloak.representations.idm.authorization.UserPolicyRepresentation;

public class UserPolicyProvider
implements PolicyProvider {
    private final Function<Policy, UserPolicyRepresentation> representationFunction;

    public UserPolicyProvider(Function<Policy, UserPolicyRepresentation> representationFunction) {
        this.representationFunction = representationFunction;
    }

    public void evaluate(Evaluation evaluation) {
        EvaluationContext context = evaluation.getContext();
        UserPolicyRepresentation representation = this.representationFunction.apply(evaluation.getPolicy());
        for (String userId : representation.getUsers()) {
            if (!context.getIdentity().getId().equals(userId)) continue;
            evaluation.grant();
            break;
        }
    }

    public void close() {
    }
}

