/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.policy.provider.time;

import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;
import org.keycloak.Config;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.model.Policy;
import org.keycloak.authorization.policy.provider.PolicyProvider;
import org.keycloak.authorization.policy.provider.PolicyProviderFactory;
import org.keycloak.authorization.policy.provider.time.TimePolicyProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.representations.idm.authorization.PolicyRepresentation;
import org.keycloak.representations.idm.authorization.TimePolicyRepresentation;

public class TimePolicyProviderFactory
implements PolicyProviderFactory<TimePolicyRepresentation> {
    private TimePolicyProvider provider = new TimePolicyProvider();

    public String getName() {
        return "Time";
    }

    public String getGroup() {
        return "Time Based";
    }

    public PolicyProvider create(AuthorizationProvider authorization) {
        return this.provider;
    }

    public PolicyProvider create(KeycloakSession session) {
        return null;
    }

    public void onCreate(Policy policy, TimePolicyRepresentation representation, AuthorizationProvider authorization) {
        this.updatePolicy(policy, representation);
    }

    public void onUpdate(Policy policy, TimePolicyRepresentation representation, AuthorizationProvider authorization) {
        this.updatePolicy(policy, representation);
    }

    public void onRemove(Policy policy, AuthorizationProvider authorization) {
    }

    public void onImport(Policy policy, PolicyRepresentation representation, AuthorizationProvider authorization) {
        policy.setConfig(representation.getConfig());
    }

    public Class<TimePolicyRepresentation> getRepresentationType() {
        return TimePolicyRepresentation.class;
    }

    public TimePolicyRepresentation toRepresentation(Policy policy, TimePolicyRepresentation representation) {
        Map config = policy.getConfig();
        representation.setDayMonth((String)config.get("dayMonth"));
        representation.setDayMonthEnd((String)config.get("dayMonthEnd"));
        representation.setMonth((String)config.get("month"));
        representation.setMonthEnd((String)config.get("monthEnd"));
        representation.setYear((String)config.get("year"));
        representation.setYearEnd((String)config.get("yearEnd"));
        representation.setHour((String)config.get("hour"));
        representation.setHourEnd((String)config.get("hourEnd"));
        representation.setMinute((String)config.get("minute"));
        representation.setMinuteEnd((String)config.get("minuteEnd"));
        representation.setNotBefore((String)config.get("nbf"));
        representation.setNotOnOrAfter((String)config.get("noa"));
        return representation;
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public void close() {
    }

    public String getId() {
        return "time";
    }

    private void updatePolicy(Policy policy, TimePolicyRepresentation representation) {
        String nbf = representation.getNotBefore();
        String noa = representation.getNotOnOrAfter();
        if (nbf != null && noa != null) {
            this.validateFormat(nbf);
            this.validateFormat(noa);
        }
        HashMap<String, String> config = new HashMap<String, String>(policy.getConfig());
        config.compute("nbf", (s, s2) -> nbf != null ? nbf : null);
        config.compute("noa", (s, s2) -> noa != null ? noa : null);
        config.compute("dayMonth", (s, s2) -> representation.getDayMonth() != null ? representation.getDayMonth() : null);
        config.compute("dayMonthEnd", (s, s2) -> representation.getDayMonthEnd() != null ? representation.getDayMonthEnd() : null);
        config.compute("month", (s, s2) -> representation.getMonth() != null ? representation.getMonth() : null);
        config.compute("monthEnd", (s, s2) -> representation.getMonthEnd() != null ? representation.getMonthEnd() : null);
        config.compute("year", (s, s2) -> representation.getYear() != null ? representation.getYear() : null);
        config.compute("yearEnd", (s, s2) -> representation.getYearEnd() != null ? representation.getYearEnd() : null);
        config.compute("hour", (s, s2) -> representation.getHour() != null ? representation.getHour() : null);
        config.compute("hourEnd", (s, s2) -> representation.getHourEnd() != null ? representation.getHourEnd() : null);
        config.compute("minute", (s, s2) -> representation.getMinute() != null ? representation.getMinute() : null);
        config.compute("minuteEnd", (s, s2) -> representation.getMinuteEnd() != null ? representation.getMinuteEnd() : null);
        policy.setConfig(config);
    }

    private void validateFormat(String date) {
        try {
            new SimpleDateFormat(TimePolicyProvider.DEFAULT_DATE_PATTERN).parse(TimePolicyProvider.format(date));
        }
        catch (Exception e) {
            throw new RuntimeException("Could not parse a date using format [" + date + "]");
        }
    }
}

