/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.introspect;

import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.AnnotatedConstructor;
import com.fasterxml.jackson.databind.introspect.AnnotatedField;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethodMap;
import com.fasterxml.jackson.databind.introspect.AnnotationMap;
import com.fasterxml.jackson.databind.introspect.ClassIntrospector;
import com.fasterxml.jackson.databind.introspect.MemberKey;
import com.fasterxml.jackson.databind.util.Annotations;
import com.fasterxml.jackson.databind.util.ClassUtil;
import java.lang.annotation.Annotation;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class AnnotatedClass
extends Annotated {
    private static final AnnotationMap[] NO_ANNOTATION_MAPS = new AnnotationMap[0];
    protected final Class<?> _class;
    protected final List<Class<?>> _superTypes;
    protected final AnnotationIntrospector _annotationIntrospector;
    protected final ClassIntrospector.MixInResolver _mixInResolver;
    protected final Class<?> _primaryMixIn;
    protected AnnotationMap _classAnnotations;
    protected boolean _creatorsResolved = false;
    protected AnnotatedConstructor _defaultConstructor;
    protected List<AnnotatedConstructor> _constructors;
    protected List<AnnotatedMethod> _creatorMethods;
    protected AnnotatedMethodMap _memberMethods;
    protected List<AnnotatedField> _fields;

    private AnnotatedClass(Class<?> cls, List<Class<?>> superTypes, AnnotationIntrospector aintr, ClassIntrospector.MixInResolver mir, AnnotationMap classAnnotations) {
        this._class = cls;
        this._superTypes = superTypes;
        this._annotationIntrospector = aintr;
        this._mixInResolver = mir;
        this._primaryMixIn = this._mixInResolver == null ? null : this._mixInResolver.findMixInClassFor(this._class);
        this._classAnnotations = classAnnotations;
    }

    @Override
    public AnnotatedClass withAnnotations(AnnotationMap ann) {
        return new AnnotatedClass(this._class, this._superTypes, this._annotationIntrospector, this._mixInResolver, ann);
    }

    public static AnnotatedClass construct(Class<?> cls, AnnotationIntrospector aintr, ClassIntrospector.MixInResolver mir) {
        return new AnnotatedClass(cls, ClassUtil.findSuperTypes(cls, null), aintr, mir, null);
    }

    public static AnnotatedClass constructWithoutSuperTypes(Class<?> cls, AnnotationIntrospector aintr, ClassIntrospector.MixInResolver mir) {
        return new AnnotatedClass(cls, Collections.<Class<?>>emptyList(), aintr, mir, null);
    }

    @Override
    public Class<?> getAnnotated() {
        return this._class;
    }

    @Override
    public int getModifiers() {
        return this._class.getModifiers();
    }

    @Override
    public String getName() {
        return this._class.getName();
    }

    @Override
    public <A extends Annotation> A getAnnotation(Class<A> acls) {
        if (this._classAnnotations == null) {
            this.resolveClassAnnotations();
        }
        return this._classAnnotations.get(acls);
    }

    @Override
    public Type getGenericType() {
        return this._class;
    }

    @Override
    public Class<?> getRawType() {
        return this._class;
    }

    @Override
    public Iterable<Annotation> annotations() {
        if (this._classAnnotations == null) {
            this.resolveClassAnnotations();
        }
        return this._classAnnotations.annotations();
    }

    @Override
    protected AnnotationMap getAllAnnotations() {
        if (this._classAnnotations == null) {
            this.resolveClassAnnotations();
        }
        return this._classAnnotations;
    }

    public Annotations getAnnotations() {
        if (this._classAnnotations == null) {
            this.resolveClassAnnotations();
        }
        return this._classAnnotations;
    }

    public boolean hasAnnotations() {
        if (this._classAnnotations == null) {
            this.resolveClassAnnotations();
        }
        return this._classAnnotations.size() > 0;
    }

    public AnnotatedConstructor getDefaultConstructor() {
        if (!this._creatorsResolved) {
            this.resolveCreators();
        }
        return this._defaultConstructor;
    }

    public List<AnnotatedConstructor> getConstructors() {
        if (!this._creatorsResolved) {
            this.resolveCreators();
        }
        return this._constructors;
    }

    public List<AnnotatedMethod> getStaticMethods() {
        if (!this._creatorsResolved) {
            this.resolveCreators();
        }
        return this._creatorMethods;
    }

    public Iterable<AnnotatedMethod> memberMethods() {
        if (this._memberMethods == null) {
            this.resolveMemberMethods();
        }
        return this._memberMethods;
    }

    public int getMemberMethodCount() {
        if (this._memberMethods == null) {
            this.resolveMemberMethods();
        }
        return this._memberMethods.size();
    }

    public AnnotatedMethod findMethod(String name, Class<?>[] paramTypes) {
        if (this._memberMethods == null) {
            this.resolveMemberMethods();
        }
        return this._memberMethods.find(name, paramTypes);
    }

    public int getFieldCount() {
        if (this._fields == null) {
            this.resolveFields();
        }
        return this._fields.size();
    }

    public Iterable<AnnotatedField> fields() {
        if (this._fields == null) {
            this.resolveFields();
        }
        return this._fields;
    }

    private void resolveClassAnnotations() {
        this._classAnnotations = new AnnotationMap();
        if (this._annotationIntrospector != null) {
            if (this._primaryMixIn != null) {
                this._addClassMixIns(this._classAnnotations, this._class, this._primaryMixIn);
            }
            this._addAnnotationsIfNotPresent(this._classAnnotations, this._class.getDeclaredAnnotations());
            for (Class<?> cls : this._superTypes) {
                this._addClassMixIns(this._classAnnotations, cls);
                this._addAnnotationsIfNotPresent(this._classAnnotations, cls.getDeclaredAnnotations());
            }
            this._addClassMixIns(this._classAnnotations, Object.class);
        }
    }

    private void resolveCreators() {
        Constructor<?>[] declaredCtors;
        ArrayList<AnnotatedConstructor> constructors = null;
        for (Constructor<?> ctor : declaredCtors = this._class.getDeclaredConstructors()) {
            if (ctor.getParameterTypes().length == 0) {
                this._defaultConstructor = this._constructConstructor(ctor, true);
                continue;
            }
            if (constructors == null) {
                constructors = new ArrayList<AnnotatedConstructor>(Math.max(10, declaredCtors.length));
            }
            constructors.add(this._constructConstructor(ctor, false));
        }
        this._constructors = constructors == null ? Collections.emptyList() : constructors;
        if (!(this._primaryMixIn == null || this._defaultConstructor == null && this._constructors.isEmpty())) {
            this._addConstructorMixIns(this._primaryMixIn);
        }
        if (this._annotationIntrospector != null) {
            if (this._defaultConstructor != null && this._annotationIntrospector.hasIgnoreMarker(this._defaultConstructor)) {
                this._defaultConstructor = null;
            }
            if (this._constructors != null) {
                int i = this._constructors.size();
                while (--i >= 0) {
                    if (!this._annotationIntrospector.hasIgnoreMarker(this._constructors.get(i))) continue;
                    this._constructors.remove(i);
                }
            }
        }
        ArrayList<AnnotatedMethod> creatorMethods = null;
        for (Method m : this._findClassMethods(this._class)) {
            if (!Modifier.isStatic(m.getModifiers())) continue;
            if (creatorMethods == null) {
                creatorMethods = new ArrayList<AnnotatedMethod>(8);
            }
            creatorMethods.add(this._constructCreatorMethod(m));
        }
        if (creatorMethods == null) {
            this._creatorMethods = Collections.emptyList();
        } else {
            this._creatorMethods = creatorMethods;
            if (this._primaryMixIn != null) {
                this._addFactoryMixIns(this._primaryMixIn);
            }
            if (this._annotationIntrospector != null) {
                int i = this._creatorMethods.size();
                while (--i >= 0) {
                    if (!this._annotationIntrospector.hasIgnoreMarker(this._creatorMethods.get(i))) continue;
                    this._creatorMethods.remove(i);
                }
            }
        }
        this._creatorsResolved = true;
    }

    private void resolveMemberMethods() {
        Class<?> mixin;
        this._memberMethods = new AnnotatedMethodMap();
        AnnotatedMethodMap mixins = new AnnotatedMethodMap();
        this._addMemberMethods(this._class, this._memberMethods, this._primaryMixIn, mixins);
        for (Class<?> cls : this._superTypes) {
            Class<?> mixin2 = this._mixInResolver == null ? null : this._mixInResolver.findMixInClassFor(cls);
            this._addMemberMethods(cls, this._memberMethods, mixin2, mixins);
        }
        if (this._mixInResolver != null && (mixin = this._mixInResolver.findMixInClassFor(Object.class)) != null) {
            this._addMethodMixIns(this._class, this._memberMethods, mixin, mixins);
        }
        if (this._annotationIntrospector != null && !mixins.isEmpty()) {
            for (AnnotatedMethod mixIn : mixins) {
                try {
                    Method m = Object.class.getDeclaredMethod(mixIn.getName(), mixIn.getRawParameterTypes());
                    if (m == null) continue;
                    AnnotatedMethod am = this._constructMethod(m);
                    this._addMixOvers(mixIn.getAnnotated(), am, false);
                    this._memberMethods.add(am);
                }
                catch (Exception e) {}
            }
        }
    }

    private void resolveFields() {
        Map<String, AnnotatedField> foundFields = this._findFields(this._class, null);
        if (foundFields == null || foundFields.size() == 0) {
            this._fields = Collections.emptyList();
        } else {
            this._fields = new ArrayList<AnnotatedField>(foundFields.size());
            this._fields.addAll(foundFields.values());
        }
    }

    protected void _addClassMixIns(AnnotationMap annotations, Class<?> toMask) {
        if (this._mixInResolver != null) {
            this._addClassMixIns(annotations, toMask, this._mixInResolver.findMixInClassFor(toMask));
        }
    }

    protected void _addClassMixIns(AnnotationMap annotations, Class<?> toMask, Class<?> mixin) {
        if (mixin == null) {
            return;
        }
        this._addAnnotationsIfNotPresent(annotations, mixin.getDeclaredAnnotations());
        for (Class<?> parent : ClassUtil.findSuperTypes(mixin, toMask)) {
            this._addAnnotationsIfNotPresent(annotations, parent.getDeclaredAnnotations());
        }
    }

    protected void _addConstructorMixIns(Class<?> mixin) {
        MemberKey[] ctorKeys = null;
        int ctorCount = this._constructors == null ? 0 : this._constructors.size();
        block0: for (Constructor<?> ctor : mixin.getDeclaredConstructors()) {
            if (ctor.getParameterTypes().length == 0) {
                if (this._defaultConstructor == null) continue;
                this._addMixOvers(ctor, this._defaultConstructor, false);
                continue;
            }
            if (ctorKeys == null) {
                ctorKeys = new MemberKey[ctorCount];
                for (int i = 0; i < ctorCount; ++i) {
                    ctorKeys[i] = new MemberKey((Constructor<?>)this._constructors.get(i).getAnnotated());
                }
            }
            MemberKey key = new MemberKey(ctor);
            for (int i = 0; i < ctorCount; ++i) {
                if (!key.equals(ctorKeys[i])) continue;
                this._addMixOvers(ctor, this._constructors.get(i), true);
                continue block0;
            }
        }
    }

    protected void _addFactoryMixIns(Class<?> mixin) {
        MemberKey[] methodKeys = null;
        int methodCount = this._creatorMethods.size();
        block0: for (Method m : mixin.getDeclaredMethods()) {
            if (!Modifier.isStatic(m.getModifiers()) || m.getParameterTypes().length == 0) continue;
            if (methodKeys == null) {
                methodKeys = new MemberKey[methodCount];
                for (int i = 0; i < methodCount; ++i) {
                    methodKeys[i] = new MemberKey(this._creatorMethods.get(i).getAnnotated());
                }
            }
            MemberKey key = new MemberKey(m);
            for (int i = 0; i < methodCount; ++i) {
                if (!key.equals(methodKeys[i])) continue;
                this._addMixOvers(m, this._creatorMethods.get(i), true);
                continue block0;
            }
        }
    }

    protected void _addMemberMethods(Class<?> cls, AnnotatedMethodMap methods, Class<?> mixInCls, AnnotatedMethodMap mixIns) {
        if (mixInCls != null) {
            this._addMethodMixIns(cls, methods, mixInCls, mixIns);
        }
        if (cls == null) {
            return;
        }
        for (Method m : this._findClassMethods(cls)) {
            if (!this._isIncludableMemberMethod(m)) continue;
            AnnotatedMethod old = methods.find(m);
            if (old == null) {
                AnnotatedMethod newM = this._constructMethod(m);
                methods.add(newM);
                old = mixIns.remove(m);
                if (old == null) continue;
                this._addMixOvers(old.getAnnotated(), newM, false);
                continue;
            }
            this._addMixUnders(m, old);
            if (!old.getDeclaringClass().isInterface() || m.getDeclaringClass().isInterface()) continue;
            methods.add(old.withMethod(m));
        }
    }

    protected void _addMethodMixIns(Class<?> targetClass, AnnotatedMethodMap methods, Class<?> mixInCls, AnnotatedMethodMap mixIns) {
        ArrayList parents = new ArrayList();
        parents.add(mixInCls);
        ClassUtil.findSuperTypes(mixInCls, targetClass, parents);
        for (Class clazz : parents) {
            for (Method m : clazz.getDeclaredMethods()) {
                if (!this._isIncludableMemberMethod(m)) continue;
                AnnotatedMethod am = methods.find(m);
                if (am != null) {
                    this._addMixUnders(m, am);
                    continue;
                }
                am = mixIns.find(m);
                if (am != null) {
                    this._addMixUnders(m, am);
                    continue;
                }
                mixIns.add(this._constructMethod(m));
            }
        }
    }

    protected Map<String, AnnotatedField> _findFields(Class<?> c, Map<String, AnnotatedField> fields) {
        Class<?> parent = c.getSuperclass();
        if (parent != null) {
            Class<?> mixin;
            fields = this._findFields(parent, fields);
            for (Field f : c.getDeclaredFields()) {
                if (!this._isIncludableField(f)) continue;
                if (fields == null) {
                    fields = new LinkedHashMap<String, AnnotatedField>();
                }
                fields.put(f.getName(), this._constructField(f));
            }
            if (this._mixInResolver != null && (mixin = this._mixInResolver.findMixInClassFor(c)) != null) {
                this._addFieldMixIns(parent, mixin, fields);
            }
        }
        return fields;
    }

    protected void _addFieldMixIns(Class<?> targetClass, Class<?> mixInCls, Map<String, AnnotatedField> fields) {
        ArrayList parents = new ArrayList();
        parents.add(mixInCls);
        ClassUtil.findSuperTypes(mixInCls, targetClass, parents);
        for (Class clazz : parents) {
            for (Field mixinField : clazz.getDeclaredFields()) {
                String name;
                AnnotatedField maskedField;
                if (!this._isIncludableField(mixinField) || (maskedField = fields.get(name = mixinField.getName())) == null) continue;
                this._addOrOverrideAnnotations(maskedField, mixinField.getDeclaredAnnotations());
            }
        }
    }

    protected AnnotatedMethod _constructMethod(Method m) {
        if (this._annotationIntrospector == null) {
            return new AnnotatedMethod(this, m, this._emptyAnnotationMap(), null);
        }
        return new AnnotatedMethod(this, m, this._collectRelevantAnnotations(m.getDeclaredAnnotations()), null);
    }

    protected AnnotatedConstructor _constructConstructor(Constructor<?> ctor, boolean defaultCtor) {
        if (this._annotationIntrospector == null) {
            return new AnnotatedConstructor(this, ctor, this._emptyAnnotationMap(), this._emptyAnnotationMaps(ctor.getParameterTypes().length));
        }
        if (defaultCtor) {
            return new AnnotatedConstructor(this, ctor, this._collectRelevantAnnotations(ctor.getDeclaredAnnotations()), null);
        }
        Annotation[][] paramAnns = ctor.getParameterAnnotations();
        int paramCount = ctor.getParameterTypes().length;
        AnnotationMap[] resolvedAnnotations = null;
        if (paramCount != paramAnns.length) {
            Class<?> dc = ctor.getDeclaringClass();
            if (dc.isEnum() && paramCount == paramAnns.length + 2) {
                Annotation[][] old = paramAnns;
                paramAnns = new Annotation[old.length + 2][];
                System.arraycopy(old, 0, paramAnns, 2, old.length);
                resolvedAnnotations = this._collectRelevantAnnotations(paramAnns);
            } else if (dc.isMemberClass() && paramCount == paramAnns.length + 1) {
                Annotation[][] old = paramAnns;
                paramAnns = new Annotation[old.length + 1][];
                System.arraycopy(old, 0, paramAnns, 1, old.length);
                resolvedAnnotations = this._collectRelevantAnnotations(paramAnns);
            }
            if (resolvedAnnotations == null) {
                throw new IllegalStateException("Internal error: constructor for " + ctor.getDeclaringClass().getName() + " has mismatch: " + paramCount + " parameters; " + paramAnns.length + " sets of annotations");
            }
        } else {
            resolvedAnnotations = this._collectRelevantAnnotations(paramAnns);
        }
        return new AnnotatedConstructor(this, ctor, this._collectRelevantAnnotations(ctor.getDeclaredAnnotations()), resolvedAnnotations);
    }

    protected AnnotatedMethod _constructCreatorMethod(Method m) {
        if (this._annotationIntrospector == null) {
            return new AnnotatedMethod(this, m, this._emptyAnnotationMap(), this._emptyAnnotationMaps(m.getParameterTypes().length));
        }
        return new AnnotatedMethod(this, m, this._collectRelevantAnnotations(m.getDeclaredAnnotations()), this._collectRelevantAnnotations(m.getParameterAnnotations()));
    }

    protected AnnotatedField _constructField(Field f) {
        if (this._annotationIntrospector == null) {
            return new AnnotatedField(this, f, this._emptyAnnotationMap());
        }
        return new AnnotatedField(this, f, this._collectRelevantAnnotations(f.getDeclaredAnnotations()));
    }

    private AnnotationMap _emptyAnnotationMap() {
        return new AnnotationMap();
    }

    private AnnotationMap[] _emptyAnnotationMaps(int count) {
        if (count == 0) {
            return NO_ANNOTATION_MAPS;
        }
        AnnotationMap[] maps = new AnnotationMap[count];
        for (int i = 0; i < count; ++i) {
            maps[i] = this._emptyAnnotationMap();
        }
        return maps;
    }

    protected boolean _isIncludableMemberMethod(Method m) {
        if (Modifier.isStatic(m.getModifiers())) {
            return false;
        }
        if (m.isSynthetic() || m.isBridge()) {
            return false;
        }
        int pcount = m.getParameterTypes().length;
        return pcount <= 2;
    }

    private boolean _isIncludableField(Field f) {
        if (f.isSynthetic()) {
            return false;
        }
        int mods = f.getModifiers();
        return !Modifier.isStatic(mods) && !Modifier.isTransient(mods);
    }

    protected AnnotationMap[] _collectRelevantAnnotations(Annotation[][] anns) {
        int len = anns.length;
        AnnotationMap[] result = new AnnotationMap[len];
        for (int i = 0; i < len; ++i) {
            result[i] = this._collectRelevantAnnotations(anns[i]);
        }
        return result;
    }

    protected AnnotationMap _collectRelevantAnnotations(Annotation[] anns) {
        return this._addAnnotationsIfNotPresent(new AnnotationMap(), anns);
    }

    private AnnotationMap _addAnnotationsIfNotPresent(AnnotationMap result, Annotation[] anns) {
        if (anns != null) {
            List<Annotation> fromBundles = null;
            for (Annotation ann : anns) {
                boolean wasNotPresent = result.addIfNotPresent(ann);
                if (!wasNotPresent || !this._isAnnotationBundle(ann)) continue;
                fromBundles = this._addFromBundle(ann, fromBundles);
            }
            if (fromBundles != null) {
                this._addAnnotationsIfNotPresent(result, fromBundles.toArray(new Annotation[fromBundles.size()]));
            }
        }
        return result;
    }

    private List<Annotation> _addFromBundle(Annotation bundle, List<Annotation> result) {
        for (Annotation a : bundle.annotationType().getDeclaredAnnotations()) {
            if (a instanceof Target || a instanceof Retention) continue;
            if (result == null) {
                result = new ArrayList<Annotation>();
            }
            result.add(a);
        }
        return result;
    }

    private void _addAnnotationsIfNotPresent(AnnotatedMember target, Annotation[] anns) {
        if (anns != null) {
            List<Annotation> fromBundles = null;
            for (Annotation ann : anns) {
                boolean wasNotPresent = target.addIfNotPresent(ann);
                if (!wasNotPresent || !this._isAnnotationBundle(ann)) continue;
                fromBundles = this._addFromBundle(ann, fromBundles);
            }
            if (fromBundles != null) {
                this._addAnnotationsIfNotPresent(target, fromBundles.toArray(new Annotation[fromBundles.size()]));
            }
        }
    }

    private void _addOrOverrideAnnotations(AnnotatedMember target, Annotation[] anns) {
        if (anns != null) {
            List<Annotation> fromBundles = null;
            for (Annotation ann : anns) {
                boolean wasModified = target.addOrOverride(ann);
                if (!wasModified || !this._isAnnotationBundle(ann)) continue;
                fromBundles = this._addFromBundle(ann, fromBundles);
            }
            if (fromBundles != null) {
                this._addOrOverrideAnnotations(target, fromBundles.toArray(new Annotation[fromBundles.size()]));
            }
        }
    }

    protected void _addMixOvers(Constructor<?> mixin, AnnotatedConstructor target, boolean addParamAnnotations) {
        this._addOrOverrideAnnotations(target, mixin.getDeclaredAnnotations());
        if (addParamAnnotations) {
            Annotation[][] pa = mixin.getParameterAnnotations();
            int len = pa.length;
            for (int i = 0; i < len; ++i) {
                for (Annotation a : pa[i]) {
                    target.addOrOverrideParam(i, a);
                }
            }
        }
    }

    protected void _addMixOvers(Method mixin, AnnotatedMethod target, boolean addParamAnnotations) {
        this._addOrOverrideAnnotations(target, mixin.getDeclaredAnnotations());
        if (addParamAnnotations) {
            Annotation[][] pa = mixin.getParameterAnnotations();
            int len = pa.length;
            for (int i = 0; i < len; ++i) {
                for (Annotation a : pa[i]) {
                    target.addOrOverrideParam(i, a);
                }
            }
        }
    }

    protected void _addMixUnders(Method src, AnnotatedMethod target) {
        this._addAnnotationsIfNotPresent(target, src.getDeclaredAnnotations());
    }

    private final boolean _isAnnotationBundle(Annotation ann) {
        return this._annotationIntrospector != null && this._annotationIntrospector.isAnnotationBundle(ann);
    }

    protected Method[] _findClassMethods(Class<?> cls) {
        try {
            return cls.getDeclaredMethods();
        }
        catch (NoClassDefFoundError ex) {
            Class<?> contextClass;
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            if (loader == null) {
                throw ex;
            }
            try {
                contextClass = loader.loadClass(cls.getName());
            }
            catch (ClassNotFoundException e) {
                throw ex;
            }
            return contextClass.getDeclaredMethods();
        }
    }

    @Override
    public String toString() {
        return "[AnnotedClass " + this._class.getName() + "]";
    }

    @Override
    public int hashCode() {
        return this._class.getName().hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        return ((AnnotatedClass)o)._class == this._class;
    }
}

