/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.authorization;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.logging.Logger;
import org.keycloak.AuthorizationContext;
import org.keycloak.KeycloakSecurityContext;
import org.keycloak.adapters.OIDCHttpFacade;
import org.keycloak.adapters.authorization.PathMatcher;
import org.keycloak.adapters.authorization.PolicyEnforcer;
import org.keycloak.adapters.spi.HttpFacade;
import org.keycloak.authorization.client.AuthzClient;
import org.keycloak.authorization.client.ClientAuthorizationContext;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.adapters.config.PolicyEnforcerConfig;
import org.keycloak.representations.idm.authorization.Permission;

public abstract class AbstractPolicyEnforcer {
    private static Logger LOGGER = Logger.getLogger(AbstractPolicyEnforcer.class);
    private final PolicyEnforcerConfig enforcerConfig;
    private final PolicyEnforcer policyEnforcer;
    private Map<String, PolicyEnforcerConfig.PathConfig> paths;
    private AuthzClient authzClient;
    private PathMatcher pathMatcher;

    public AbstractPolicyEnforcer(PolicyEnforcer policyEnforcer) {
        this.policyEnforcer = policyEnforcer;
        this.enforcerConfig = policyEnforcer.getEnforcerConfig();
        this.authzClient = policyEnforcer.getClient();
        this.pathMatcher = policyEnforcer.getPathMatcher();
        this.paths = policyEnforcer.getPaths();
    }

    public AuthorizationContext authorize(OIDCHttpFacade httpFacade) {
        AccessToken accessToken;
        PolicyEnforcerConfig.EnforcementMode enforcementMode = this.enforcerConfig.getEnforcementMode();
        if (PolicyEnforcerConfig.EnforcementMode.DISABLED.equals((Object)enforcementMode)) {
            return this.createEmptyAuthorizationContext(true);
        }
        KeycloakSecurityContext securityContext = httpFacade.getSecurityContext();
        if (securityContext != null && (accessToken = securityContext.getToken()) != null) {
            HttpFacade.Request request = httpFacade.getRequest();
            String path = this.getPath(request);
            PolicyEnforcerConfig.PathConfig pathConfig = this.pathMatcher.matches(path, this.paths);
            LOGGER.debugf("Checking permissions for path [%s] with config [%s].", (Object)request.getURI(), (Object)pathConfig);
            if (pathConfig == null) {
                if (PolicyEnforcerConfig.EnforcementMode.PERMISSIVE.equals((Object)enforcementMode)) {
                    return this.createAuthorizationContext(accessToken, null);
                }
                LOGGER.debugf("Could not find a configuration for path [%s]", (Object)path);
                if (this.isDefaultAccessDeniedUri(request, this.enforcerConfig)) {
                    return this.createAuthorizationContext(accessToken, null);
                }
                this.handleAccessDenied(httpFacade);
                return this.createEmptyAuthorizationContext(false);
            }
            if (PolicyEnforcerConfig.EnforcementMode.DISABLED.equals((Object)pathConfig.getEnforcementMode())) {
                return this.createEmptyAuthorizationContext(true);
            }
            PolicyEnforcerConfig.MethodConfig methodConfig = this.getRequiredScopes(pathConfig, request);
            if (this.isAuthorized(pathConfig, methodConfig, accessToken, httpFacade)) {
                try {
                    return this.createAuthorizationContext(accessToken, pathConfig);
                }
                catch (Exception e) {
                    throw new RuntimeException("Error processing path [" + pathConfig.getPath() + "].", e);
                }
            }
            LOGGER.debugf("Sending challenge to the client. Path [%s]", (Object)pathConfig);
            if (!this.challenge(pathConfig, methodConfig, httpFacade)) {
                LOGGER.debugf("Challenge not sent, sending default forbidden response. Path [%s]", (Object)pathConfig);
                this.handleAccessDenied(httpFacade);
            }
        }
        return this.createEmptyAuthorizationContext(false);
    }

    protected abstract boolean challenge(PolicyEnforcerConfig.PathConfig var1, PolicyEnforcerConfig.MethodConfig var2, OIDCHttpFacade var3);

    protected boolean isAuthorized(PolicyEnforcerConfig.PathConfig actualPathConfig, PolicyEnforcerConfig.MethodConfig methodConfig, AccessToken accessToken, OIDCHttpFacade httpFacade) {
        PolicyEnforcerConfig enforcerConfig;
        HttpFacade.Request request = httpFacade.getRequest();
        if (this.isDefaultAccessDeniedUri(request, enforcerConfig = this.getEnforcerConfig())) {
            return true;
        }
        AccessToken.Authorization authorization = accessToken.getAuthorization();
        if (authorization == null) {
            return false;
        }
        List<Permission> permissions = authorization.getPermissions();
        boolean hasPermission = false;
        for (Permission permission : permissions) {
            if (permission.getResourceSetId() != null) {
                if (!this.isResourcePermission(actualPathConfig, permission)) continue;
                hasPermission = true;
                if (actualPathConfig.isInstance() && !this.matchResourcePermission(actualPathConfig, permission) || !this.hasResourceScopePermission(methodConfig, permission)) continue;
                LOGGER.debugf("Authorization GRANTED for path [%s]. Permissions [%s].", (Object)actualPathConfig, (Object)permissions);
                if (request.getMethod().equalsIgnoreCase("DELETE") && actualPathConfig.isInstance()) {
                    this.paths.remove(actualPathConfig);
                }
                return true;
            }
            if (!this.hasResourceScopePermission(methodConfig, permission)) continue;
            hasPermission = true;
            return true;
        }
        if (!hasPermission && PolicyEnforcerConfig.EnforcementMode.PERMISSIVE.equals((Object)actualPathConfig.getEnforcementMode())) {
            return true;
        }
        LOGGER.debugf("Authorization FAILED for path [%s]. Not enough permissions [%s].", (Object)actualPathConfig, (Object)permissions);
        return false;
    }

    protected void handleAccessDenied(OIDCHttpFacade httpFacade) {
        httpFacade.getResponse().sendError(403);
    }

    private boolean isDefaultAccessDeniedUri(HttpFacade.Request request, PolicyEnforcerConfig enforcerConfig) {
        String accessDeniedPath = enforcerConfig.getOnDenyRedirectTo();
        return accessDeniedPath != null && request.getURI().contains(accessDeniedPath);
    }

    private boolean hasResourceScopePermission(PolicyEnforcerConfig.MethodConfig methodConfig, Permission permission) {
        List<String> requiredScopes = methodConfig.getScopes();
        Set<String> allowedScopes = permission.getScopes();
        if (allowedScopes.isEmpty()) {
            return true;
        }
        PolicyEnforcerConfig.ScopeEnforcementMode enforcementMode = methodConfig.getScopesEnforcementMode();
        if (PolicyEnforcerConfig.ScopeEnforcementMode.ALL.equals((Object)enforcementMode)) {
            return allowedScopes.containsAll(requiredScopes);
        }
        if (PolicyEnforcerConfig.ScopeEnforcementMode.ANY.equals((Object)enforcementMode)) {
            for (String requiredScope : requiredScopes) {
                if (!allowedScopes.contains(requiredScope)) continue;
                return true;
            }
        }
        return requiredScopes.isEmpty();
    }

    protected AuthzClient getAuthzClient() {
        return this.authzClient;
    }

    protected PolicyEnforcerConfig getEnforcerConfig() {
        return this.enforcerConfig;
    }

    protected PolicyEnforcer getPolicyEnforcer() {
        return this.policyEnforcer;
    }

    private AuthorizationContext createEmptyAuthorizationContext(final boolean granted) {
        return new ClientAuthorizationContext(this.authzClient){

            public boolean hasPermission(String resourceName, String scopeName) {
                return granted;
            }

            public boolean hasResourcePermission(String resourceName) {
                return granted;
            }

            public boolean hasScopePermission(String scopeName) {
                return granted;
            }

            public List<Permission> getPermissions() {
                return Collections.EMPTY_LIST;
            }

            public boolean isGranted() {
                return granted;
            }
        };
    }

    private String getPath(HttpFacade.Request request) {
        return request.getRelativePath();
    }

    private PolicyEnforcerConfig.MethodConfig getRequiredScopes(PolicyEnforcerConfig.PathConfig pathConfig, HttpFacade.Request request) {
        String method = request.getMethod();
        for (PolicyEnforcerConfig.MethodConfig methodConfig : pathConfig.getMethods()) {
            if (!methodConfig.getMethod().equals(method)) continue;
            return methodConfig;
        }
        PolicyEnforcerConfig.MethodConfig methodConfig = new PolicyEnforcerConfig.MethodConfig();
        methodConfig.setMethod(request.getMethod());
        methodConfig.setScopes(pathConfig.getScopes());
        methodConfig.setScopesEnforcementMode(PolicyEnforcerConfig.ScopeEnforcementMode.ANY);
        return methodConfig;
    }

    private AuthorizationContext createAuthorizationContext(AccessToken accessToken, PolicyEnforcerConfig.PathConfig pathConfig) {
        return new ClientAuthorizationContext(accessToken, pathConfig, this.paths, this.authzClient);
    }

    private boolean isResourcePermission(PolicyEnforcerConfig.PathConfig actualPathConfig, Permission permission) {
        boolean resourceMatch = this.matchResourcePermission(actualPathConfig, permission);
        if (!resourceMatch && actualPathConfig.isInstance()) {
            resourceMatch = this.matchResourcePermission(actualPathConfig.getParentConfig(), permission);
        }
        return resourceMatch;
    }

    private boolean matchResourcePermission(PolicyEnforcerConfig.PathConfig actualPathConfig, Permission permission) {
        return permission.getResourceSetId().equals(actualPathConfig.getId());
    }
}

