/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.adapters.authorization;

import java.util.ArrayList;
import java.util.HashSet;
import org.jboss.logging.Logger;
import org.keycloak.KeycloakSecurityContext;
import org.keycloak.adapters.KeycloakDeployment;
import org.keycloak.adapters.OIDCHttpFacade;
import org.keycloak.adapters.authorization.AbstractPolicyEnforcer;
import org.keycloak.adapters.authorization.PolicyEnforcer;
import org.keycloak.adapters.rotation.AdapterRSATokenVerifier;
import org.keycloak.adapters.spi.HttpFacade;
import org.keycloak.authorization.client.AuthorizationDeniedException;
import org.keycloak.authorization.client.AuthzClient;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.adapters.config.PolicyEnforcerConfig;
import org.keycloak.representations.idm.authorization.AuthorizationRequest;
import org.keycloak.representations.idm.authorization.AuthorizationResponse;
import org.keycloak.representations.idm.authorization.Permission;
import org.keycloak.representations.idm.authorization.PermissionRequest;
import org.keycloak.representations.idm.authorization.PermissionResponse;

public class KeycloakAdapterPolicyEnforcer
extends AbstractPolicyEnforcer {
    private static Logger LOGGER = Logger.getLogger(KeycloakAdapterPolicyEnforcer.class);

    public KeycloakAdapterPolicyEnforcer(PolicyEnforcer policyEnforcer) {
        super(policyEnforcer);
    }

    @Override
    protected boolean isAuthorized(PolicyEnforcerConfig.PathConfig pathConfig, PolicyEnforcerConfig.MethodConfig methodConfig, AccessToken accessToken, OIDCHttpFacade httpFacade) {
        AccessToken.Authorization newAuthorization;
        AccessToken original = accessToken;
        if (super.isAuthorized(pathConfig, methodConfig, accessToken, httpFacade)) {
            return true;
        }
        accessToken = this.requestAuthorizationToken(pathConfig, methodConfig, httpFacade);
        if (accessToken == null) {
            return false;
        }
        AccessToken.Authorization authorization = original.getAuthorization();
        if (authorization == null) {
            authorization = new AccessToken.Authorization();
            authorization.setPermissions(new ArrayList<Permission>());
        }
        if ((newAuthorization = accessToken.getAuthorization()) != null) {
            authorization.getPermissions().addAll(newAuthorization.getPermissions());
        }
        original.setAuthorization(authorization);
        return super.isAuthorized(pathConfig, methodConfig, accessToken, httpFacade);
    }

    @Override
    protected boolean challenge(PolicyEnforcerConfig.PathConfig pathConfig, PolicyEnforcerConfig.MethodConfig methodConfig, OIDCHttpFacade facade) {
        this.handleAccessDenied(facade);
        return true;
    }

    @Override
    protected void handleAccessDenied(OIDCHttpFacade facade) {
        KeycloakSecurityContext securityContext = facade.getSecurityContext();
        if (securityContext == null) {
            return;
        }
        String accessDeniedPath = this.getEnforcerConfig().getOnDenyRedirectTo();
        HttpFacade.Response response = facade.getResponse();
        if (accessDeniedPath != null) {
            response.setStatus(302);
            response.setHeader("Location", accessDeniedPath);
        } else {
            response.sendError(403);
        }
    }

    private AccessToken requestAuthorizationToken(PolicyEnforcerConfig.PathConfig pathConfig, PolicyEnforcerConfig.MethodConfig methodConfig, OIDCHttpFacade httpFacade) {
        try {
            AuthorizationRequest authzRequest;
            KeycloakSecurityContext securityContext = httpFacade.getSecurityContext();
            String accessTokenString = securityContext.getTokenString();
            AuthzClient authzClient = this.getAuthzClient();
            KeycloakDeployment deployment = this.getPolicyEnforcer().getDeployment();
            PermissionRequest permissionRequest = new PermissionRequest();
            permissionRequest.setResourceId(pathConfig.getId());
            permissionRequest.setScopes(new HashSet<String>(methodConfig.getScopes()));
            AccessToken accessToken = securityContext.getToken();
            if (this.getEnforcerConfig().getUserManagedAccess() != null) {
                PermissionResponse permissionResponse = authzClient.protection().permission().create(permissionRequest);
                authzRequest = new AuthorizationRequest();
                authzRequest.setTicket(permissionResponse.getTicket());
            } else {
                authzRequest = new AuthorizationRequest();
                if (accessToken.getAuthorization() != null) {
                    authzRequest.addPermission(pathConfig.getId(), methodConfig.getScopes());
                }
            }
            if (accessToken.getAuthorization() != null) {
                authzRequest.setRpt(accessTokenString);
            }
            LOGGER.debug("Obtaining authorization for authenticated user.");
            AuthorizationResponse authzResponse = authzClient.authorization(accessTokenString).authorize(authzRequest);
            if (authzResponse != null) {
                return AdapterRSATokenVerifier.verifyToken(authzResponse.getToken(), deployment);
            }
            return null;
        }
        catch (AuthorizationDeniedException e) {
            LOGGER.debug((Object)"Authorization denied", e);
            return null;
        }
        catch (Exception e) {
            throw new RuntimeException("Unexpected error during authorization request.", e);
        }
    }
}

