/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.crypto;

import org.keycloak.common.VerificationException;
import org.keycloak.crypto.KeyWrapper;
import org.keycloak.crypto.SignatureException;
import org.keycloak.crypto.SignatureSignerContext;
import org.keycloak.crypto.SignatureVerifierContext;
import org.keycloak.provider.Provider;

public interface SignatureProvider
extends Provider {
    public static void checkKeyForSignature(KeyWrapper key, String algorithm, String type) throws SignatureException {
        if (!type.equals(key.getType()) || !algorithm.equals(key.getAlgorithmOrDefault())) {
            throw new SignatureException(String.format("Key with algorithm %s and type %s is incorrect for provider algorithm %s", key.getAlgorithm(), key.getType(), algorithm));
        }
    }

    public static void checkKeyForVerification(KeyWrapper key, String algorithm, String type) throws VerificationException {
        if (!type.equals(key.getType()) || !algorithm.equals(key.getAlgorithmOrDefault())) {
            throw new VerificationException(String.format("Key with algorithm %s and type %s is incorrect for provider algorithm %s", key.getAlgorithm(), key.getType(), algorithm));
        }
    }

    public SignatureSignerContext signer() throws SignatureException;

    public SignatureSignerContext signer(KeyWrapper var1) throws SignatureException;

    public SignatureVerifierContext verifier(String var1) throws VerificationException;

    public SignatureVerifierContext verifier(KeyWrapper var1) throws VerificationException;

    public boolean isAsymmetricAlgorithm();

    @Override
    default public void close() {
    }
}

