/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.broker.provider;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.keycloak.broker.provider.BrokeredIdentityContext;
import org.keycloak.models.IdentityProviderMapperModel;
import org.keycloak.models.IdentityProviderSyncMode;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.provider.ConfiguredProvider;
import org.keycloak.provider.Provider;
import org.keycloak.provider.ProviderFactory;

public interface IdentityProviderMapper
extends Provider,
ProviderFactory<IdentityProviderMapper>,
ConfiguredProvider {
    public static final String ANY_PROVIDER = "*";
    public static final Set<IdentityProviderSyncMode> DEFAULT_IDENTITY_PROVIDER_MAPPER_SYNC_MODES = new HashSet<IdentityProviderSyncMode>(Arrays.asList(IdentityProviderSyncMode.LEGACY, IdentityProviderSyncMode.IMPORT));

    public String[] getCompatibleProviders();

    public String getDisplayCategory();

    public String getDisplayType();

    default public boolean supportsSyncMode(IdentityProviderSyncMode syncMode) {
        return DEFAULT_IDENTITY_PROVIDER_MAPPER_SYNC_MODES.contains((Object)syncMode);
    }

    public void preprocessFederatedIdentity(KeycloakSession var1, RealmModel var2, IdentityProviderMapperModel var3, BrokeredIdentityContext var4);

    public void importNewUser(KeycloakSession var1, RealmModel var2, UserModel var3, IdentityProviderMapperModel var4, BrokeredIdentityContext var5);

    public void updateBrokeredUserLegacy(KeycloakSession var1, RealmModel var2, UserModel var3, IdentityProviderMapperModel var4, BrokeredIdentityContext var5);

    public void updateBrokeredUser(KeycloakSession var1, RealmModel var2, UserModel var3, IdentityProviderMapperModel var4, BrokeredIdentityContext var5);
}

