/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models;

import java.util.Map;
import org.keycloak.common.util.ObjectUtil;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.OrderedModel;
import org.keycloak.models.ProtocolMapperContainerModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.ScopeContainerModel;
import org.keycloak.provider.ProviderEvent;
import org.keycloak.storage.SearchableModelField;

public interface ClientScopeModel
extends ProtocolMapperContainerModel,
ScopeContainerModel,
OrderedModel {
    public static final String DISPLAY_ON_CONSENT_SCREEN = "display.on.consent.screen";
    public static final String CONSENT_SCREEN_TEXT = "consent.screen.text";
    public static final String GUI_ORDER = "gui.order";
    public static final String INCLUDE_IN_TOKEN_SCOPE = "include.in.token.scope";
    public static final String IS_DYNAMIC_SCOPE = "is.dynamic.scope";
    public static final String DYNAMIC_SCOPE_REGEXP = "dynamic.scope.regexp";

    public String getId();

    public String getName();

    public RealmModel getRealm();

    public void setName(String var1);

    public String getDescription();

    public void setDescription(String var1);

    public String getProtocol();

    public void setProtocol(String var1);

    public void setAttribute(String var1, String var2);

    public void removeAttribute(String var1);

    public String getAttribute(String var1);

    public Map<String, String> getAttributes();

    default public boolean isDisplayOnConsentScreen() {
        String displayVal = this.getAttribute(DISPLAY_ON_CONSENT_SCREEN);
        return displayVal == null ? true : Boolean.parseBoolean(displayVal);
    }

    default public void setDisplayOnConsentScreen(boolean displayOnConsentScreen) {
        this.setAttribute(DISPLAY_ON_CONSENT_SCREEN, String.valueOf(displayOnConsentScreen));
    }

    default public String getConsentScreenText() {
        String consentScreenText = this.getAttribute(CONSENT_SCREEN_TEXT);
        if (ObjectUtil.isBlank(consentScreenText)) {
            consentScreenText = this.getName();
        }
        return consentScreenText;
    }

    default public void setConsentScreenText(String consentScreenText) {
        this.setAttribute(CONSENT_SCREEN_TEXT, consentScreenText);
    }

    @Override
    default public String getGuiOrder() {
        return this.getAttribute(GUI_ORDER);
    }

    default public void setGuiOrder(String guiOrder) {
        this.setAttribute(GUI_ORDER, guiOrder);
    }

    default public boolean isIncludeInTokenScope() {
        String includeInTokenScope = this.getAttribute(INCLUDE_IN_TOKEN_SCOPE);
        return includeInTokenScope == null ? true : Boolean.parseBoolean(includeInTokenScope);
    }

    default public void setIncludeInTokenScope(boolean includeInTokenScope) {
        this.setAttribute(INCLUDE_IN_TOKEN_SCOPE, String.valueOf(includeInTokenScope));
    }

    default public boolean isDynamicScope() {
        return Boolean.parseBoolean(this.getAttribute(IS_DYNAMIC_SCOPE));
    }

    default public void setIsDynamicScope(boolean isDynamicScope) {
        this.setAttribute(IS_DYNAMIC_SCOPE, String.valueOf(isDynamicScope));
    }

    default public String getDynamicScopeRegexp() {
        return this.getAttribute(DYNAMIC_SCOPE_REGEXP);
    }

    public static interface ClientScopeRemovedEvent
    extends ProviderEvent {
        public ClientScopeModel getClientScope();

        public KeycloakSession getKeycloakSession();
    }

    public static class SearchableFields {
        public static final SearchableModelField<ClientScopeModel> ID = new SearchableModelField("id", String.class);
        public static final SearchableModelField<ClientScopeModel> REALM_ID = new SearchableModelField("realmId", String.class);
        public static final SearchableModelField<ClientScopeModel> NAME = new SearchableModelField("name", String.class);
    }
}

