/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.validate.validators;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.keycloak.provider.ConfiguredProvider;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.validate.SimpleValidator;
import org.keycloak.validate.ValidationContext;
import org.keycloak.validate.ValidationError;
import org.keycloak.validate.ValidatorConfig;

public class UriValidator
implements SimpleValidator,
ConfiguredProvider {
    public static final UriValidator INSTANCE = new UriValidator();
    public static final String KEY_ALLOWED_SCHEMES = "allowedSchemes";
    public static final String KEY_ALLOW_FRAGMENT = "allowFragment";
    public static final String KEY_REQUIRE_VALID_URL = "requireValidUrl";
    public static final Set<String> DEFAULT_ALLOWED_SCHEMES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("http", "https")));
    public static final String MESSAGE_INVALID_URI = "error-invalid-uri";
    public static final String MESSAGE_INVALID_SCHEME = "error-invalid-uri-scheme";
    public static final String MESSAGE_INVALID_FRAGMENT = "error-invalid-uri-fragment";
    public static boolean DEFAULT_ALLOW_FRAGMENT = true;
    public static boolean DEFAULT_REQUIRE_VALID_URL = true;
    public static final String ID = "uri";

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public ValidationContext validate(Object input, String inputHint, ValidationContext context, ValidatorConfig config) {
        if (input == null || input instanceof String && ((String)input).isEmpty()) {
            return context;
        }
        try {
            URI uri = this.toUri(input);
            if (uri == null) {
                context.addError(new ValidationError(ID, inputHint, MESSAGE_INVALID_URI, input));
            } else {
                Set<String> allowedSchemes = config.getStringSetOrDefault(KEY_ALLOWED_SCHEMES, DEFAULT_ALLOWED_SCHEMES);
                boolean allowFragment = config.getBooleanOrDefault(KEY_ALLOW_FRAGMENT, DEFAULT_ALLOW_FRAGMENT);
                boolean requireValidUrl = config.getBooleanOrDefault(KEY_REQUIRE_VALID_URL, DEFAULT_REQUIRE_VALID_URL);
                this.validateUri(uri, inputHint, context, allowedSchemes, allowFragment, requireValidUrl);
            }
        }
        catch (IllegalArgumentException | MalformedURLException | URISyntaxException e) {
            context.addError(new ValidationError(ID, inputHint, MESSAGE_INVALID_URI, input, e.getMessage()));
        }
        return context;
    }

    private URI toUri(Object input) throws URISyntaxException {
        if (input instanceof String) {
            String uriString = (String)input;
            return new URI(uriString);
        }
        if (input instanceof URI) {
            return (URI)input;
        }
        if (input instanceof URL) {
            return ((URL)input).toURI();
        }
        return null;
    }

    public boolean validateUri(URI uri, Set<String> allowedSchemes, boolean allowFragment, boolean requireValidUrl) {
        try {
            return this.validateUri(uri, "url", new ValidationContext(), allowedSchemes, allowFragment, requireValidUrl);
        }
        catch (MalformedURLException mue) {
            return false;
        }
    }

    public boolean validateUri(URI uri, String inputHint, ValidationContext context, Set<String> allowedSchemes, boolean allowFragment, boolean requireValidUrl) throws MalformedURLException {
        boolean valid = true;
        if (uri.getScheme() != null && !allowedSchemes.contains(uri.getScheme())) {
            context.addError(new ValidationError(ID, inputHint, MESSAGE_INVALID_SCHEME, uri, uri.getScheme()));
            valid = false;
        }
        if (!allowFragment && uri.getFragment() != null) {
            context.addError(new ValidationError(ID, inputHint, MESSAGE_INVALID_FRAGMENT, uri, uri.getFragment()));
            valid = false;
        }
        if (requireValidUrl && valid) {
            URL uRL = uri.toURL();
        }
        return valid;
    }

    @Override
    public String getHelpText() {
        return "Uri Validator";
    }

    @Override
    public List<ProviderConfigProperty> getConfigProperties() {
        return Collections.emptyList();
    }
}

