/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.cl.parser;

import java.util.ArrayList;
import java.util.List;
import org.jboss.aesh.cl.CommandLine;
import org.jboss.aesh.cl.internal.ProcessedCommand;
import org.jboss.aesh.cl.parser.AeshCommandLineCompletionParser;
import org.jboss.aesh.cl.parser.AeshCommandLineParserHelper;
import org.jboss.aesh.cl.parser.CommandLineCompletionParser;
import org.jboss.aesh.cl.parser.CommandLineParser;
import org.jboss.aesh.cl.parser.CommandLineParserException;
import org.jboss.aesh.cl.populator.CommandPopulator;
import org.jboss.aesh.console.Config;
import org.jboss.aesh.console.command.Command;
import org.jboss.aesh.parser.AeshLine;
import org.jboss.aesh.parser.Parser;
import org.jboss.aesh.parser.ParserStatus;

public class AeshCommandLineParser<C extends Command>
implements CommandLineParser<C> {
    private final ProcessedCommand<C> processedCommand;
    private static final String EQUALS = "=";
    private List<CommandLineParser<? extends Command>> childParsers;
    private boolean isChild = false;

    public AeshCommandLineParser(ProcessedCommand<C> processedCommand) {
        this.processedCommand = processedCommand;
    }

    @Override
    public void addChildParser(CommandLineParser<? extends Command> commandLineParser) {
        if (this.childParsers == null) {
            this.childParsers = new ArrayList<CommandLineParser<? extends Command>>();
        }
        commandLineParser.setChild(true);
        this.childParsers.add(commandLineParser);
    }

    public List<CommandLineParser<? extends Command>> getChildParsers() {
        return this.childParsers;
    }

    @Override
    public void setChild(boolean child) {
        this.isChild = child;
    }

    @Override
    public List<String> getAllNames() {
        if (this.isGroupCommand()) {
            List<CommandLineParser<Command>> parsers = this.getChildParsers();
            ArrayList<String> names = new ArrayList<String>(parsers.size());
            for (CommandLineParser<Command> child : parsers) {
                names.add(this.processedCommand.getName() + " " + child.getProcessedCommand().getName());
            }
            return names;
        }
        ArrayList<String> names = new ArrayList<String>(1);
        names.add(this.processedCommand.getName());
        return names;
    }

    public boolean isChild() {
        return this.isChild;
    }

    @Override
    public CommandLineParser<? extends Command> getChildParser(String name) {
        if (!this.isGroupCommand()) {
            return null;
        }
        for (CommandLineParser<Command> clp : this.getChildParsers()) {
            if (!clp.getProcessedCommand().getName().equals(name)) continue;
            return clp;
        }
        return null;
    }

    @Override
    public List<CommandLineParser<? extends Command>> getAllChildParsers() {
        if (this.isGroupCommand()) {
            return this.getChildParsers();
        }
        return new ArrayList<CommandLineParser<? extends Command>>();
    }

    @Override
    public ProcessedCommand<C> getProcessedCommand() {
        return this.processedCommand;
    }

    @Override
    public C getCommand() {
        return this.processedCommand.getCommand();
    }

    @Override
    public CommandLineCompletionParser getCompletionParser() {
        return new AeshCommandLineCompletionParser(this);
    }

    @Override
    public CommandPopulator getCommandPopulator() {
        return this.processedCommand.getCommandPopulator();
    }

    @Override
    public String printHelp() {
        List<CommandLineParser<Command>> parsers = this.getChildParsers();
        if (parsers != null && parsers.size() > 0) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.processedCommand.printHelp()).append(Config.getLineSeparator()).append(this.processedCommand.getName()).append(" commands:").append(Config.getLineSeparator());
            for (CommandLineParser<Command> child : parsers) {
                sb.append("    ").append(child.getProcessedCommand().getName()).append(Config.getLineSeparator());
            }
            return sb.toString();
        }
        return this.processedCommand.printHelp();
    }

    @Override
    public CommandLine<? extends Command> parse(String line) {
        return this.parse(line, false);
    }

    @Override
    public CommandLine<? extends Command> parse(AeshLine line, boolean ignoreRequirements) {
        if (line.getWords().size() > 0) {
            if (this.processedCommand.getName().equals(line.getWords().get(0)) || this.processedCommand.getAliases().contains(line.getWords().get(0))) {
                if (this.isGroupCommand() && line.getWords().size() > 1) {
                    CommandLineParser<Command> clp = this.getChildParser(line.getWords().get(1));
                    if (clp == null) {
                        return this.parse(line.getWords(), ignoreRequirements);
                    }
                    return clp.parse(line.getWords(), ignoreRequirements);
                }
                return this.parse(line.getWords(), ignoreRequirements);
            }
        } else if (line.getStatus() != ParserStatus.OK) {
            return new CommandLine(new CommandLineParserException(line.getErrorMessage()));
        }
        return new CommandLine(new CommandLineParserException("Command:" + this.processedCommand + ", not found in: " + line));
    }

    @Override
    public CommandLine<? extends Command> parse(String line, boolean ignoreRequirements) {
        return this.parse(Parser.findAllWords(line), ignoreRequirements);
    }

    @Override
    public CommandLine<? extends Command> parse(List<String> lines, boolean ignoreRequirements) {
        AeshCommandLineParserHelper helper = new AeshCommandLineParserHelper(this.processedCommand);
        lines.remove(0);
        if (this.isChild) {
            lines.remove(0);
        }
        this.clear();
        CommandLine commandLine = new CommandLine(this);
        helper.parse(commandLine, lines, ignoreRequirements);
        return commandLine;
    }

    @Override
    public void clear() {
        this.processedCommand.clear();
        if (this.isGroupCommand()) {
            for (CommandLineParser<Command> child : this.getChildParsers()) {
                child.getProcessedCommand().clear();
            }
        }
    }

    @Override
    public boolean isGroupCommand() {
        List<CommandLineParser<Command>> parsers = this.getChildParsers();
        return parsers != null && parsers.size() > 0;
    }

    public String toString() {
        return "CommandLineParser{processedCommand=" + this.processedCommand + "command=" + this.processedCommand.getCommand() + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AeshCommandLineParser)) {
            return false;
        }
        AeshCommandLineParser that = (AeshCommandLineParser)o;
        return this.processedCommand.equals(that.processedCommand);
    }

    public int hashCode() {
        return this.processedCommand.hashCode();
    }
}

