/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.client.cli.common;

import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.keycloak.client.cli.common.BaseAuthOptionsCmd;
import org.keycloak.client.cli.common.CommandState;
import org.keycloak.client.cli.util.ConfigUtil;
import org.keycloak.client.cli.util.IoUtil;
import org.keycloak.client.cli.util.OsUtil;
import picocli.CommandLine;

public class BaseConfigTruststoreCmd
extends BaseAuthOptionsCmd {
    @CommandLine.Parameters(arity="0..1")
    private String store;
    @CommandLine.Option(names={"-d", "--delete"}, description={"Remove truststore configuration"})
    private boolean delete;

    public BaseConfigTruststoreCmd(CommandState commandState) {
        super(commandState);
    }

    @Override
    protected boolean nothingToDo() {
        return super.nothingToDo() && this.store == null && !this.delete;
    }

    @Override
    protected String[] getUnsupportedOptions() {
        return new String[]{"--server", this.server, "--realm", this.realm, "--client", this.clientId, "--user", this.user, "--password", this.password, "--secret", this.secret, "--truststore", this.trustStore, "--keystore", this.keystore, "--keypass", this.keyPass, "--alias", this.alias, "--no-config", BaseConfigTruststoreCmd.booleanOptionForCheck(this.noconfig)};
    }

    @Override
    protected void process() {
        String pass;
        if (!this.delete) {
            if (this.store == null) {
                throw new IllegalArgumentException("No truststore specified");
            }
            if (!new File(this.store).isFile()) {
                throw new RuntimeException("Truststore file not found: " + this.store);
            }
            if ("-".equals(this.trustPass)) {
                this.trustPass = IoUtil.readSecret("Enter truststore password: ");
            }
            pass = this.trustPass;
        } else {
            if (this.store != null) {
                throw new IllegalArgumentException("Option --delete is mutually exclusive with specifying a TRUSTSTORE");
            }
            if (this.trustPass != null) {
                throw new IllegalArgumentException("Options --trustpass and --delete are mutually exclusive");
            }
            pass = null;
        }
        ConfigUtil.saveMergeConfig(config -> {
            config.setTruststore(this.store);
            config.setTrustpass(pass);
        });
    }

    @Override
    public String help() {
        StringWriter sb = new StringWriter();
        PrintWriter out = new PrintWriter(sb);
        out.println("Usage: " + this.getCommand() + " config truststore [TRUSTSTORE | --delete] [--trustpass PASSWORD] [ARGUMENTS]");
        out.println();
        out.println("Command to configure a global truststore to use when using https to connect to Keycloak server.");
        out.println();
        out.println("Arguments:");
        out.println();
        out.println("  Global options:");
        out.println("    -x                      Print full stack trace when exiting with error");
        out.println("    --config                Path to the config file (" + this.getDefaultConfigFilePath() + " by default)");
        out.println();
        out.println("  Command specific options:");
        out.println("    TRUSTSTORE              Path to truststore file");
        out.println("    --trustpass PASSWORD    Truststore password to unlock truststore (prompted for if set to '-'), defaults to the env variable KC_CLI_TRUSTSTORE_PASSWORD");
        out.println("    -d, --delete            Remove truststore configuration");
        out.println();
        out.println();
        out.println("Examples:");
        out.println();
        out.println("Specify a truststore - you will be prompted for truststore password every time it is used:");
        out.println("  " + OsUtil.PROMPT + " " + this.getCommand() + " config truststore " + OsUtil.OS_ARCH.path("~/.keycloak/truststore.jks"));
        out.println();
        out.println("Specify a truststore, and password - truststore will automatically be used without prompting for password:");
        out.println("  " + OsUtil.PROMPT + " " + this.getCommand() + " config truststore --trustpass " + OsUtil.OS_ARCH.envVar("PASSWORD") + " " + OsUtil.OS_ARCH.path("~/.keycloak/truststore.jks"));
        out.println();
        out.println("Remove truststore configuration:");
        out.println("  " + OsUtil.PROMPT + " " + this.getCommand() + " config truststore --delete");
        out.println();
        out.println();
        out.println("Use '" + this.getCommand() + " help' for general information and a list of commands");
        return sb.toString();
    }
}

