/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.jose.jwk;

import java.math.BigInteger;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.interfaces.EdECPublicKey;
import java.security.spec.EdECPoint;
import java.security.spec.EdECPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.NamedParameterSpec;
import java.util.Optional;
import org.keycloak.common.util.Base64Url;
import org.keycloak.common.util.KeyUtils;
import org.keycloak.crypto.KeyUse;
import org.keycloak.jose.jwk.EdECUtils;
import org.keycloak.jose.jwk.JWK;
import org.keycloak.jose.jwk.JWKBuilder;
import org.keycloak.jose.jwk.OKPPublicJWK;

class EdECUtilsImpl
implements EdECUtils {
    @Override
    public boolean isEdECSupported() {
        return true;
    }

    @Override
    public JWK okp(String kid, String algorithm, Key key, KeyUse keyUse) {
        EdECPublicKey eddsaPublicKey = (EdECPublicKey)key;
        OKPPublicJWK k = new OKPPublicJWK();
        kid = kid != null ? kid : KeyUtils.createKeyId(key);
        k.setKeyId(kid);
        k.setKeyType("OKP");
        k.setAlgorithm(algorithm);
        k.setPublicKeyUse(keyUse == null ? JWKBuilder.DEFAULT_PUBLIC_KEY_USE.getSpecName() : keyUse.getSpecName());
        k.setCrv(eddsaPublicKey.getParams().getName());
        Optional<String> x = EdECUtilsImpl.edPublicKeyInJwkRepresentation(eddsaPublicKey);
        k.setX(x.orElse(""));
        return k;
    }

    @Override
    public PublicKey createOKPPublicKey(JWK jwk) {
        String x = (String)jwk.getOtherClaims().get("x");
        String crv = (String)jwk.getOtherClaims().get("crv");
        int bytesLength = 0;
        if ("Ed25519".equals(crv)) {
            bytesLength = 32;
        } else if ("Ed448".equals(crv)) {
            bytesLength = 57;
        } else {
            throw new RuntimeException("Invalid JWK representation of OKP type algorithm");
        }
        byte[] decodedX = Base64Url.decode(x);
        if (decodedX.length != bytesLength) {
            throw new RuntimeException("Invalid JWK representation of OKP type public key");
        }
        boolean isOddX = false;
        if ((decodedX[decodedX.length - 1] & 0xFFFFFF80) != 0) {
            isOddX = true;
        }
        int n = decodedX.length - 1;
        decodedX[n] = (byte)(decodedX[n] & 0x7F);
        BigInteger y = new BigInteger(1, EdECUtilsImpl.reverseBytes(decodedX));
        NamedParameterSpec spec = new NamedParameterSpec(crv);
        EdECPoint ep = new EdECPoint(isOddX, y);
        EdECPublicKeySpec keySpec = new EdECPublicKeySpec(spec, ep);
        PublicKey publicKey = null;
        try {
            publicKey = KeyFactory.getInstance(crv).generatePublic(keySpec);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw new RuntimeException(e);
        }
        return publicKey;
    }

    private static Optional<String> edPublicKeyInJwkRepresentation(EdECPublicKey eddsaPublicKey) {
        EdECPoint edEcPoint = eddsaPublicKey.getPoint();
        BigInteger yCoordinate = edEcPoint.getY();
        int bytesLength = 0;
        if ("Ed25519".equals(eddsaPublicKey.getParams().getName())) {
            bytesLength = 32;
        } else if ("Ed448".equals(eddsaPublicKey.getParams().getName())) {
            bytesLength = 57;
        } else {
            return Optional.ofNullable(null);
        }
        byte[] yCoordinateLittleEndianBytes = new byte[bytesLength];
        byte[] yCoordinateLittleEndian = EdECUtilsImpl.reverseBytes(yCoordinate.toByteArray());
        System.arraycopy(yCoordinateLittleEndian, 0, yCoordinateLittleEndianBytes, 0, yCoordinateLittleEndian.length);
        if (edEcPoint.isXOdd()) {
            int n = yCoordinateLittleEndianBytes.length - 1;
            yCoordinateLittleEndianBytes[n] = (byte)(yCoordinateLittleEndianBytes[n] | 0xFFFFFF80);
        }
        return Optional.ofNullable(Base64Url.encode(yCoordinateLittleEndianBytes));
    }

    private static byte[] reverseBytes(byte[] array) {
        if (array == null || array.length == 0) {
            return null;
        }
        int length = array.length;
        byte[] reversedArray = new byte[length];
        for (int i = 0; i < length; ++i) {
            reversedArray[length - 1 - i] = array[i];
        }
        return reversedArray;
    }
}

