/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.client.registration;

import org.apache.http.HttpRequest;
import org.keycloak.common.util.Base64;
import org.keycloak.representations.idm.ClientInitialAccessPresentation;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.oidc.OIDCClientRepresentation;

public abstract class Auth {
    public abstract void addAuth(HttpRequest var1);

    public static Auth token(String token) {
        return new BearerTokenAuth(token);
    }

    public static Auth token(ClientInitialAccessPresentation initialAccess) {
        return new BearerTokenAuth(initialAccess.getToken());
    }

    public static Auth token(ClientRepresentation client) {
        return new BearerTokenAuth(client.getRegistrationAccessToken());
    }

    public static Auth token(OIDCClientRepresentation client) {
        return new BearerTokenAuth(client.getRegistrationAccessToken());
    }

    public static Auth client(String clientId, String clientSecret) {
        return new BasicAuth(clientId, clientSecret);
    }

    private static class BasicAuth
    extends Auth {
        private String username;
        private String password;

        public BasicAuth(String username, String password) {
            this.username = username;
            this.password = password;
        }

        @Override
        public void addAuth(HttpRequest request) {
            String val = Base64.encodeBytes((byte[])(this.username + ":" + this.password).getBytes());
            request.setHeader("Authorization", "Basic " + val);
        }
    }

    private static class BearerTokenAuth
    extends Auth {
        private String token;

        public BearerTokenAuth(String token) {
            this.token = token;
        }

        @Override
        public void addAuth(HttpRequest request) {
            request.setHeader("Authorization", "Bearer " + this.token);
        }
    }
}

