/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.sessions;

import java.util.Map;
import java.util.Objects;
import org.keycloak.models.ClientModel;
import org.keycloak.models.RealmModel;
import org.keycloak.util.EnumWithStableIndex;

public interface CommonClientSessionModel {
    public String getRedirectUri();

    public void setRedirectUri(String var1);

    public RealmModel getRealm();

    public ClientModel getClient();

    public String getAction();

    public void setAction(String var1);

    public String getProtocol();

    public void setProtocol(String var1);

    public static enum ExecutionStatus implements EnumWithStableIndex
    {
        FAILED(0),
        SUCCESS(1),
        SETUP_REQUIRED(2),
        ATTEMPTED(3),
        SKIPPED(4),
        CHALLENGED(5),
        EVALUATED_TRUE(6),
        EVALUATED_FALSE(7);

        private final int stableIndex;
        private static final Map<Integer, ExecutionStatus> BY_ID;

        private ExecutionStatus(int stableIndex) {
            Objects.requireNonNull(stableIndex);
            this.stableIndex = stableIndex;
        }

        @Override
        public int getStableIndex() {
            return this.stableIndex;
        }

        public static ExecutionStatus valueOfInteger(Integer id) {
            return id == null ? null : BY_ID.get(id);
        }

        static {
            BY_ID = EnumWithStableIndex.getReverseIndex((EnumWithStableIndex[])ExecutionStatus.values());
        }
    }

    public static enum Action {
        OAUTH_GRANT,
        AUTHENTICATE,
        LOGGED_OUT,
        LOGGING_OUT,
        REQUIRED_ACTIONS,
        USER_CODE_VERIFICATION;

    }
}

