/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.validation;

import javax.ws.rs.BadRequestException;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.representations.oidc.OIDCClientRepresentation;
import org.keycloak.validation.ClientValidationContext;
import org.keycloak.validation.ClientValidationProvider;
import org.keycloak.validation.ValidationContext;
import org.keycloak.validation.ValidationResult;

public class ValidationUtil {
    public static void validateClient(KeycloakSession session, ClientModel client, boolean create, ErrorHandler errorHandler) throws BadRequestException {
        ValidationUtil.validateClient(session, client, null, create, errorHandler);
    }

    public static void validateClient(KeycloakSession session, ClientModel client, OIDCClientRepresentation oidcClient, boolean create, ErrorHandler errorHandler) throws BadRequestException {
        ClientValidationProvider provider = session.getProvider(ClientValidationProvider.class);
        if (provider != null) {
            ValidationContext.Event event = create ? ValidationContext.Event.CREATE : ValidationContext.Event.UPDATE;
            ValidationResult result = oidcClient != null ? provider.validate(new ClientValidationContext.OIDCContext(event, session, client, oidcClient)) : provider.validate(new ClientValidationContext(event, session, client));
            if (!result.isValid()) {
                errorHandler.onError(result);
            }
        }
    }

    public static interface ErrorHandler {
        public void onError(ValidationResult var1);
    }
}

